/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.base;

import java.util.Arrays;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.tbk.nostr.base.Kind;

public final class EventUri {
    @NonNull
    private final Kind kind;
    private final byte[] publicKey;
    @Nullable
    private final String identifier;

    public static boolean isValidEventUriString(String value) {
        return EventUri.tryParse(value).isPresent();
    }

    public static EventUri of(int kind, String publicKeyHex) {
        return EventUri.of(Kind.of(kind), publicKeyHex);
    }

    public static EventUri of(Kind kind, @NonNull String publicKeyHex) {
        if (publicKeyHex == null) {
            throw new IllegalArgumentException("publicKeyHex is marked non-null but is null");
        }
        return EventUri.parse("%d:%s".formatted(kind.getValue(), publicKeyHex));
    }

    public static EventUri of(int kind, @NonNull String publicKeyHex, @NonNull String identifier) {
        if (publicKeyHex == null) {
            throw new IllegalArgumentException("publicKeyHex is marked non-null but is null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier is marked non-null but is null");
        }
        return EventUri.of(Kind.of(kind), publicKeyHex, identifier);
    }

    public static EventUri of(Kind kind, @NonNull String publicKeyHex, @NonNull String identifier) {
        if (publicKeyHex == null) {
            throw new IllegalArgumentException("publicKeyHex is marked non-null but is null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier is marked non-null but is null");
        }
        return EventUri.parse("%d:%s:%s".formatted(kind.getValue(), publicKeyHex, identifier));
    }

    public static EventUri parse(String value) {
        try {
            String[] split = value.split(":", 3);
            if (split.length < 2) {
                throw new IllegalArgumentException("Invalid string.");
            }
            String kindString = split[0];
            String supposedPublicKey = split[1];
            if (supposedPublicKey.length() != 64) {
                throw new IllegalArgumentException("Invalid pubkey string.");
            }
            String identifier = split.length != 3 ? null : split[2];
            return new EventUri(Kind.parse(kindString), supposedPublicKey, identifier);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while parsing event uri: " + e.getMessage());
        }
    }

    public static Optional<EventUri> tryParse(String value) {
        try {
            return Optional.of(EventUri.parse(value));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private EventUri(Kind kind, String publicKeyHex, @Nullable String identifier) {
        byte[] publicKey = EventUri.parsePublicKey(publicKeyHex);
        if (!EventUri.looksLikePublicKey(publicKey)) {
            throw new IllegalArgumentException("Invalid pubkey.");
        }
        this.kind = Objects.requireNonNull(kind);
        this.publicKey = publicKey;
        this.identifier = identifier;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public String getPublicKeyHex() {
        return HexFormat.of().formatHex(this.publicKey);
    }

    public String toString() {
        return this.identifier == null ? "%d:%s".formatted(this.kind.getValue(), this.getPublicKeyHex()) : "%d:%s:%s".formatted(this.kind.getValue(), this.getPublicKeyHex(), this.identifier);
    }

    private static boolean looksLikePublicKey(byte[] raw) {
        return raw.length == 32;
    }

    private static byte[] parsePublicKey(String publicKeyHex) {
        try {
            return HexFormat.of().parseHex(publicKeyHex);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid pubkey.");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventUri)) {
            return false;
        }
        EventUri other = (EventUri)o;
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        Optional<String> this$identifier = this.getIdentifier();
        Optional<String> other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        Optional<String> $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        return result;
    }

    @NonNull
    public Kind getKind() {
        return this.kind;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }
}

