/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.base;

import java.util.Optional;

public final class Kind
implements Comparable<Kind> {
    private static final int MIN_KIND_VALUE = 0;
    private static final int MAX_KIND_VALUE = 65535;
    private final int value;

    public static boolean isValidKindString(String kindString) {
        try {
            return Kind.isValidKind(Integer.parseInt(kindString));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidKind(int kind) {
        return kind >= 0 && kind <= 65535;
    }

    public static int minValue() {
        return 0;
    }

    public static int maxValue() {
        return 65535;
    }

    public static Kind min() {
        return Kind.of(0);
    }

    public static Kind max() {
        return Kind.of(65535);
    }

    public static Kind parse(String kindString) {
        if (!Kind.isValidKindString(kindString)) {
            throw new IllegalArgumentException("Kind must be between %d and %d".formatted(0, 65535));
        }
        return Kind.of(Integer.parseInt(kindString));
    }

    public static Optional<Kind> tryParse(String kindString) {
        try {
            return Optional.of(Kind.parse(kindString));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Kind of(int kind) {
        return new Kind(kind);
    }

    private Kind(int value) {
        if (!Kind.isValidKind(value)) {
            throw new IllegalArgumentException("Kind must be between %d and %d".formatted(0, 65535));
        }
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Kind anotherKind) {
        return Integer.compare(this.value, anotherKind.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Kind)) {
            return false;
        }
        Kind other = (Kind)o;
        return this.getValue() == other.getValue();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        return result;
    }

    public String toString() {
        return "Kind(value=" + this.getValue() + ")";
    }
}

