/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.base;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public final class RelayUri {
    private final URI uri;

    public static boolean isValidRelayUriString(String value) {
        return RelayUri.tryParse(value).isPresent();
    }

    public static RelayUri parse(String uri) {
        return RelayUri.of(URI.create(uri));
    }

    public static Optional<RelayUri> tryParse(String uri) {
        try {
            return Optional.of(RelayUri.parse(uri));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static RelayUri of(URI uri) {
        return new RelayUri(uri);
    }

    private RelayUri(URI uri) {
        Objects.requireNonNull(uri);
        if (!"ws".equalsIgnoreCase(uri.getScheme()) && !"wss".equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme");
        }
        this.uri = uri.normalize();
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelayUri)) {
            return false;
        }
        RelayUri other = (RelayUri)o;
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        return result;
    }

    public String toString() {
        return "RelayUri(uri=" + String.valueOf(this.getUri()) + ")";
    }
}

