/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.identity;

import fr.acinq.bitcoin.DeterministicWallet;
import fr.acinq.bitcoin.KeyPath;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.XonlyPublicKey;
import lombok.NonNull;
import org.tbk.nostr.nip6.Nip6;

public class Identity {
    @NonNull
    private final DeterministicWallet.ExtendedPrivateKey masterPrivateKey;

    public Account deriveAccount(long account) {
        KeyPath keyPath = Nip6.keyPath((long)account);
        PrivateKey privateKey = Nip6.fromMasterPrivateKey((DeterministicWallet.ExtendedPrivateKey)this.masterPrivateKey, (KeyPath)keyPath);
        return Account.builder().path(keyPath).privateKey(privateKey).build();
    }

    Identity(@NonNull DeterministicWallet.ExtendedPrivateKey masterPrivateKey) {
        if (masterPrivateKey == null) {
            throw new IllegalArgumentException("masterPrivateKey is marked non-null but is null");
        }
        this.masterPrivateKey = masterPrivateKey;
    }

    public static final class Account {
        @NonNull
        private final KeyPath path;
        @NonNull
        private final PrivateKey privateKey;

        public XonlyPublicKey getPublicKey() {
            return this.privateKey.xOnlyPublicKey();
        }

        Account(@NonNull KeyPath path, @NonNull PrivateKey privateKey) {
            if (path == null) {
                throw new IllegalArgumentException("path is marked non-null but is null");
            }
            if (privateKey == null) {
                throw new IllegalArgumentException("privateKey is marked non-null but is null");
            }
            this.path = path;
            this.privateKey = privateKey;
        }

        public static AccountBuilder builder() {
            return new AccountBuilder();
        }

        @NonNull
        public KeyPath getPath() {
            return this.path;
        }

        @NonNull
        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Account)) {
                return false;
            }
            Account other = (Account)o;
            KeyPath this$path = this.getPath();
            KeyPath other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            PrivateKey this$privateKey = this.getPrivateKey();
            PrivateKey other$privateKey = other.getPrivateKey();
            return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KeyPath $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            PrivateKey $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            return result;
        }

        public String toString() {
            return "Identity.Account(path=" + String.valueOf(this.getPath()) + ", privateKey=" + String.valueOf(this.getPrivateKey()) + ")";
        }

        public static class AccountBuilder {
            private KeyPath path;
            private PrivateKey privateKey;

            AccountBuilder() {
            }

            public AccountBuilder path(@NonNull KeyPath path) {
                if (path == null) {
                    throw new IllegalArgumentException("path is marked non-null but is null");
                }
                this.path = path;
                return this;
            }

            public AccountBuilder privateKey(@NonNull PrivateKey privateKey) {
                if (privateKey == null) {
                    throw new IllegalArgumentException("privateKey is marked non-null but is null");
                }
                this.privateKey = privateKey;
                return this;
            }

            public Account build() {
                return new Account(this.path, this.privateKey);
            }

            public String toString() {
                return "Identity.Account.AccountBuilder(path=" + String.valueOf(this.path) + ", privateKey=" + String.valueOf(this.privateKey) + ")";
            }
        }
    }
}

