/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.identity;

import fr.acinq.bitcoin.DeterministicWallet;
import fr.acinq.bitcoin.MnemonicCode;
import java.util.HexFormat;
import java.util.List;
import org.tbk.nostr.identity.Identity;
import org.tbk.nostr.identity.MoreRandom;

public final class MoreIdentities {
    private MoreIdentities() {
        throw new UnsupportedOperationException();
    }

    public static Identity random() {
        return MoreIdentities.fromSeed(MoreRandom.randomByteArray(256));
    }

    public static Identity fromSeedHex(String hex) {
        return MoreIdentities.fromSeed(HexFormat.of().parseHex(hex));
    }

    public static Identity fromSeed(byte[] seed) {
        return new Identity(DeterministicWallet.generate((byte[])seed));
    }

    public static Identity.Account fromSeed(byte[] seed, long accountIndex) {
        return MoreIdentities.fromSeed(seed).deriveAccount(accountIndex);
    }

    public static Identity fromMnemonic(String mnemonic) {
        return MoreIdentities.fromMnemonic(mnemonic, "");
    }

    public static Identity fromMnemonic(String mnemonic, String passphrase) {
        return MoreIdentities.fromSeed(MnemonicCode.toSeed((String)mnemonic, (String)passphrase));
    }

    public static Identity fromMnemonic(List<String> mnemonic) {
        return MoreIdentities.fromMnemonic(mnemonic, "");
    }

    public static Identity fromMnemonic(List<String> mnemonic, String passphrase) {
        return MoreIdentities.fromMnemonic(String.join((CharSequence)" ", mnemonic), passphrase);
    }
}

