/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.identity;

import com.google.protobuf.ByteString;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVector64;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.XonlyPublicKey;
import java.util.HexFormat;
import java.util.Objects;
import org.tbk.nostr.base.EventId;
import org.tbk.nostr.base.Kinds;
import org.tbk.nostr.identity.Identity;
import org.tbk.nostr.identity.MoreIdentities;
import org.tbk.nostr.identity.MoreRandom;
import org.tbk.nostr.identity.Signer;
import org.tbk.nostr.proto.Event;
import org.tbk.nostr.proto.EventOrBuilder;

public class SimpleSigner
implements Signer {
    private final PrivateKey privateKey;

    public static SimpleSigner random() {
        return SimpleSigner.fromIdentity(MoreIdentities.random());
    }

    public static SimpleSigner fromPrivateKeyHex(String hex) {
        return SimpleSigner.fromPrivateKey(PrivateKey.fromHex((String)hex));
    }

    public static SimpleSigner fromPrivateKey(PrivateKey privateKey) {
        return new SimpleSigner(privateKey);
    }

    public static SimpleSigner fromIdentity(Identity identity) {
        return SimpleSigner.fromAccount(identity.deriveAccount(0L));
    }

    public static SimpleSigner fromAccount(Identity.Account account) {
        return SimpleSigner.fromPrivateKey(account.getPrivateKey());
    }

    private SimpleSigner(PrivateKey privateKey) {
        if (!privateKey.isValid()) {
            throw new IllegalArgumentException("Invalid key");
        }
        this.privateKey = Objects.requireNonNull(privateKey);
    }

    @Override
    public XonlyPublicKey getPublicKey() {
        return this.privateKey.publicKey().xOnly();
    }

    @Override
    public Event.Builder sign(Event.Builder builder) {
        if (builder.getKind() == Kinds.kindDirectMessage.getValue()) {
            throw new IllegalArgumentException("Cannot sign event with kind %d".formatted(Kinds.kindDirectMessage.getValue()));
        }
        return this.signUnsafe(builder);
    }

    public Event.Builder signUnsafe(Event.Builder builder) {
        if (builder.getId().isEmpty()) {
            throw new IllegalArgumentException("Missing id");
        }
        try {
            ByteVector32 data = ByteVector32.fromValidHex((String)EventId.of((EventOrBuilder)builder).toHex());
            ByteVector32 auxRand = ByteVector32.fromValidHex((String)HexFormat.of().formatHex(MoreRandom.randomByteArray(32)));
            ByteVector64 signature = Crypto.signSchnorr((ByteVector32)data, (PrivateKey)this.privateKey, (Crypto.SchnorrTweak)Crypto.SchnorrTweak.NoTweak.INSTANCE, (ByteVector32)auxRand);
            return builder.setSig(ByteString.copyFrom((byte[])signature.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

