/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.nip6;

import com.google.common.annotations.VisibleForTesting;
import fr.acinq.bitcoin.DeterministicWallet;
import fr.acinq.bitcoin.KeyPath;
import fr.acinq.bitcoin.MnemonicCode;
import fr.acinq.bitcoin.PrivateKey;
import reactor.core.publisher.Flux;

public final class Nip6 {
    private static final KeyPath nip6Base = new KeyPath("").derive(DeterministicWallet.hardened((long)44L)).derive(DeterministicWallet.hardened((long)1237L));

    public static KeyPath keyPath(long account) {
        return nip6Base.derive(DeterministicWallet.hardened((long)account)).derive(0L).derive(0L);
    }

    private Nip6() {
        throw new UnsupportedOperationException();
    }

    public static PrivateKey fromSeed(byte[] seed) {
        return Nip6.fromSeed(seed, 0L);
    }

    public static PrivateKey fromSeed(byte[] seed, long account) {
        return Nip6.fromMasterPrivateKey(DeterministicWallet.generate((byte[])seed), account);
    }

    public static PrivateKey fromSeed(byte[] seed, KeyPath keyPath) {
        return Nip6.fromMasterPrivateKey(DeterministicWallet.generate((byte[])seed), keyPath);
    }

    public static Flux<PrivateKey> generateFromSeed(byte[] seed) {
        DeterministicWallet.ExtendedPrivateKey masterPrivateKey = DeterministicWallet.generate((byte[])seed);
        return Flux.generate(() -> 0L, (i, sink) -> {
            sink.next((Object)Nip6.fromMasterPrivateKey(masterPrivateKey, i));
            return i + 1L;
        });
    }

    private static PrivateKey fromMasterPrivateKey(DeterministicWallet.ExtendedPrivateKey masterPrivateKey, long account) {
        return Nip6.fromMasterPrivateKey(masterPrivateKey, Nip6.keyPath(account));
    }

    public static PrivateKey fromMasterPrivateKey(DeterministicWallet.ExtendedPrivateKey masterPrivateKey, KeyPath keyPath) {
        return DeterministicWallet.derivePrivateKey((DeterministicWallet.ExtendedPrivateKey)masterPrivateKey, (KeyPath)keyPath).getPrivateKey();
    }

    public static PrivateKey testVector0() {
        return Nip6.fromSeed(Nip6.testVector0Seed());
    }

    public static PrivateKey testVector1() {
        return Nip6.fromSeed(Nip6.testVector1Seed());
    }

    @VisibleForTesting
    static byte[] testVector0Seed() {
        return MnemonicCode.toSeed((String)"leader monkey parrot ring guide accident before fence cannon height naive bean", (String)"");
    }

    @VisibleForTesting
    static byte[] testVector1Seed() {
        return MnemonicCode.toSeed((String)"what bleak badge arrange retreat wolf trade produce cricket blur garlic valid proud rude strong choose busy staff weather area salt hollow arm fade", (String)"");
    }
}

