/*
 * Decompiled with CFR 0.152.
 */
package io.github.therealarthurdent.maven.jsonpath.boundary;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    @Parameter(property="jsonpath.file", required=true)
    protected String file;

    public abstract void execute() throws MojoExecutionException;

    protected DocumentContext getDocumentContext() throws MojoExecutionException {
        DocumentContext json;
        FileSystem fs = FileSystems.getDefault();
        Path inputJson = fs.getPath(this.file, new String[0]);
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
        try (InputStream in = Files.newInputStream(inputJson, new OpenOption[0]);){
            json = JsonPath.using((Configuration)configuration).parse(in, "UTF-8");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to read input json file");
            throw new MojoExecutionException("Unable to read file '" + this.file + "'", (Exception)e);
        }
        return json;
    }
}

