/*
 * Decompiled with CFR 0.152.
 */
package io.github.therealarthurdent.maven.jsonpath.boundary;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import io.github.therealarthurdent.maven.jsonpath.boundary.AbstractMojo;
import io.github.therealarthurdent.maven.jsonpath.entity.Modification;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="modify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ModifyMojo
extends AbstractMojo {
    private static final String JSON_NODE = "jsonNode";
    @Parameter(property="jsonpath.outputFile", required=false)
    private String outputFile;
    @Parameter(required=true)
    private List<Modification> modifications;

    @Override
    public void execute() throws MojoExecutionException {
        FileSystem fs = FileSystems.getDefault();
        Path outputJson = this.outputFile == null ? fs.getPath(this.file, new String[0]) : fs.getPath(this.outputFile, new String[0]);
        DocumentContext json = this.getDocumentContext();
        int count = 0;
        for (Modification modification : this.modifications) {
            String path = modification.getPath();
            String rawValue = modification.getValue();
            String value = rawValue.startsWith(JSON_NODE) ? this.parseJsonNode(rawValue) : rawValue;
            if (modification.isAddModification()) {
                String key = modification.getKey();
                json.put(path, key, (Object)value, new Predicate[0]);
                this.getLog().info((CharSequence)("added: " + path + "." + key + "=" + value));
            } else {
                json.set(path, (Object)value, new Predicate[0]);
                this.getLog().info((CharSequence)("modified" + path + "=" + value));
            }
            ++count;
        }
        try (OutputStream out = Files.newOutputStream(outputJson, new OpenOption[0]);){
            ObjectWriter writer = new ObjectMapper().writerWithDefaultPrettyPrinter();
            writer.writeValue(out, json.json());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to write output json file");
            throw new MojoExecutionException("Unable write file '" + outputJson + "'", (Exception)e);
        }
        if (count == 0) {
            this.getLog().error((CharSequence)(count + " modifications written to json file " + outputJson));
            throw new MojoExecutionException("No modifications were defined");
        }
        this.getLog().info((CharSequence)(count + " modifications written to json file " + outputJson));
    }

    protected JsonNode parseJsonNode(String value) throws MojoExecutionException {
        JsonNode node = null;
        try {
            node = new ObjectMapper().readTree(value.substring(JSON_NODE.length() + 1));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to parse jsonNode: " + value, (Exception)e);
        }
        return node;
    }
}

