/*
 * Decompiled with CFR 0.152.
 */
package io.github.thiagolvlsantos.git.commons.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public final class FileUtils {
    public static boolean write(File file, String content) throws IOException {
        boolean ok = FileUtils.prepare(file);
        Files.write(file.toPath(), String.valueOf(content).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        return ok;
    }

    public static boolean prepare(File file) {
        File dir = file.getParentFile();
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static boolean delete(File file) throws IOException {
        boolean writable;
        if (file.isDirectory()) {
            File[] children;
            for (File c : children = file.listFiles()) {
                FileUtils.delete(c);
            }
        }
        if (!(writable = file.setWritable(true))) {
            // empty if block
        }
        Files.delete(file.toPath());
        return true;
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

