/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.jetty;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.specrunner.SRServices;
import org.specrunner.context.ContextException;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.util.string.IStringProvider;

public class JettyStringProvider
implements IStringProvider {
    public static final String FEATURE_URL = JettyStringProvider.class.getName() + ".url";
    private String url;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String newString(IContext context) throws ContextException {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_URL, (Object)this);
        if (this.url == null) {
            Server server = (Server)context.getByName("jettyName");
            if (server == null) {
                throw new ContextException("Jetty server named 'jettyName' does not exists.");
            }
            int defaultPort = 8080;
            int port = 8080;
            for (Connector c : server.getConnectors()) {
                if (!(c instanceof ServerConnector)) continue;
                port = ((ServerConnector)c).getPort();
                break;
            }
            return "http://localhost:" + port;
        }
        return this.url;
    }
}

