/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.jetty;

import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.preventers.AppContextLeakPreventer;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.context.IDestructable;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginScoped;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.util.UtilLog;

public class PluginStartJetty
extends AbstractPluginScoped {
    public static final String SERVER_NAME = "jettyName";
    private static Object lock = new Object();
    public static final String FEATURE_FILE = PluginStartJetty.class.getName() + ".file";
    private String file;
    public static final String FEATURE_DYNAMIC = PluginStartJetty.class.getName() + ".dynamic";
    private Boolean dynamic = true;
    public static final String FEATURE_PORT = PluginStartJetty.class.getName() + ".port";
    private Integer port;
    public static final String FEATURE_REUSE = PluginStartJetty.class.getName() + ".reuse";
    private Boolean reuse = false;
    public static final String FEATURE_CLASSLOADER = PluginStartJetty.class.getName() + ".classloader";
    private Boolean classloader = true;

    public PluginStartJetty() {
        this.setName(SERVER_NAME);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public Boolean getClassloader() {
        return this.classloader;
    }

    public void setClassloader(Boolean classloader) {
        this.classloader = classloader;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.file == null) {
            fm.set(FEATURE_FILE, (Object)this);
        }
        fm.set(FEATURE_DYNAMIC, (Object)this);
        if (this.port == null) {
            fm.set(FEATURE_PORT, (Object)this);
        }
        fm.set(FEATURE_REUSE, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Object object = lock;
        synchronized (object) {
            try {
                Log.getRootLogger().setDebugEnabled(true);
                if (this.file == null) {
                    throw new PluginException("Jetty file name must be set using attribute 'file'.");
                }
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Jetty version -> " + Server.getVersion() + ".");
                }
                IReuseManager reusables = (IReuseManager)SRServices.get(IReuseManager.class);
                if (this.reuse.booleanValue()) {
                    HashMap<String, String> cfg = new HashMap<String, String>();
                    cfg.put(this.getFileForJettyName(this.getName()), this.file);
                    IReusable reusable = (IReusable)reusables.get((Object)this.getName());
                    if (reusable != null && reusable.canReuse(cfg)) {
                        reusable.reset();
                        this.saveGlobal(context, this.getName(), reusable.getObject());
                        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Jetty (" + this.getName() + "/" + Server.getVersion() + ") with " + this.file + " reused.");
                        }
                        return ENext.DEEP;
                    }
                }
                Server server = this.createServer();
                LocalSessionManager sm = this.setSessionManager(server);
                if (this.dynamic.booleanValue()) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Jetty dynamic port lookup.");
                    }
                    this.scanAvailablePort(server);
                }
                this.perform(server);
                this.waitForStart(server);
                this.save(context, server);
                if (this.reuse.booleanValue()) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Jetty reuse enabled.");
                    }
                    reusables.put((Object)this.getName(), (Object)new ReusableJetty(this.getName(), server, sm));
                }
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                if (!this.reuse.booleanValue() && UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Jetty started and ready.");
                }
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
        }
        return ENext.DEEP;
    }

    protected void save(IContext context, final Server server) {
        if (this.reuse.booleanValue()) {
            this.saveGlobal(context, this.getName(), server);
        } else {
            this.saveGlobal(context, this.getName(), new IDestructable(){

                public Object getObject() {
                    return server;
                }

                public void destroy() {
                    block2: {
                        try {
                            server.stop();
                        }
                        catch (Exception e) {
                            if (!UtilLog.LOG.isDebugEnabled()) break block2;
                            UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    protected Server createServer() throws Exception {
        InputStream config = PluginStartJetty.class.getResourceAsStream(this.file);
        if (config == null) {
            throw new PluginException("Jetty file '" + this.file + "' not found.");
        }
        XmlConfiguration configuration = new XmlConfiguration(config);
        config.close();
        Server server = (Server)configuration.configure();
        server.addBean((Object)new AppContextLeakPreventer());
        this.setShutdownManager(server);
        this.getPortFromServer(server);
        this.setClassloader(server);
        return server;
    }

    protected void setShutdownManager(Server server) {
        server.setStopAtShutdown(true);
        ShutdownHandler sdh = (ShutdownHandler)server.getChildHandlerByClass(ShutdownHandler.class);
        if (sdh != null) {
            sdh.setExitJvm(false);
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Jetty System.exit(..) disabled.");
            }
        }
    }

    protected void getPortFromServer(Server server) {
        for (Connector c : server.getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            this.port = ((ServerConnector)c).getPort();
            break;
        }
    }

    protected void setClassloader(Server server) {
        WebAppContext web = (WebAppContext)server.getChildHandlerByClass(WebAppContext.class);
        if (web != null && this.classloader.booleanValue()) {
            web.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    protected LocalSessionManager setSessionManager(Server server) {
        WebAppContext web;
        LocalSessionManager sm = null;
        if (this.reuse.booleanValue() && (web = (WebAppContext)server.getChildHandlerByClass(WebAppContext.class)) != null) {
            SessionHandler h = web.getSessionHandler();
            sm = new LocalSessionManager();
            h.setSessionManager((SessionManager)sm);
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Jetty LocalSessionManager added -> " + (Object)((Object)sm) + ".");
            }
        }
        return sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanAvailablePort(Server server) throws PluginException {
        boolean available = false;
        int tries = 1000;
        for (int i = this.port.intValue(); !available && i < this.port + 1000; ++i) {
            InputStream in = null;
            Socket sock = null;
            try {
                sock = new Socket("localhost", i);
                in = sock.getInputStream();
                continue;
            }
            catch (Exception e) {
                this.port = i;
                available = true;
                continue;
            }
            finally {
                block24: {
                    block23: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                if (!UtilLog.LOG.isTraceEnabled()) break block23;
                                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (Exception e) {
                            if (!UtilLog.LOG.isTraceEnabled()) break block24;
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (!available) {
            throw new PluginException("No available port from '" + (this.port - 1000) + "' to '" + this.port + "'.");
        }
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Jetty port '" + this.port + "' available.");
        }
        for (Connector c : server.getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            ((ServerConnector)c).setPort(this.port.intValue());
            if (!UtilLog.LOG.isInfoEnabled()) break;
            UtilLog.LOG.info("Jetty port set to '" + this.port + "'.");
            break;
        }
    }

    public void perform(Server server) {
    }

    protected void waitForStart(Server server) throws Exception {
        server.start();
        while (!server.isRunning()) {
            if (!UtilLog.LOG.isInfoEnabled()) continue;
            UtilLog.LOG.info("Waiting Jetty start.");
        }
    }

    protected String getFileForJettyName(String jettyName) {
        return "file_" + jettyName;
    }

    private final class LocalSessionManager
    extends HashSessionManager {
        private LocalSessionManager() {
        }

        public void shutdownSessions() {
            block3: {
                try {
                    super.shutdownSessions();
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Sessions removed.");
                    }
                }
                catch (Exception e) {
                    if (!UtilLog.LOG.isDebugEnabled()) break block3;
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected final class ReusableJetty
    extends AbstractReusable<Server> {
        private final LocalSessionManager sessionManager;

        protected ReusableJetty(String name, Server server, LocalSessionManager sessionManager) {
            super(name, (Object)server);
            this.sessionManager = sessionManager;
        }

        public boolean canReuse(Map<String, Object> extra) {
            Object obj = extra.get(PluginStartJetty.this.getFileForJettyName(this.getName()));
            return obj != null && obj.equals(PluginStartJetty.this.file);
        }

        public void reset() {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Jetty recycling '" + this.getObject() + "'.");
            }
            for (Connector c : ((Server)this.getObject()).getConnectors()) {
                if (!(c instanceof ServerConnector)) continue;
                if (!UtilLog.LOG.isInfoEnabled()) break;
                UtilLog.LOG.info("Jetty port listening on '" + ((ServerConnector)c).getPort() + "'.");
                break;
            }
            if (this.sessionManager != null) {
                this.sessionManager.shutdownSessions();
            }
            ((Server)this.getObject()).clearAttributes();
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Jetty '" + this.getName() + "' attributes cleared.");
            }
        }

        public void release() {
            try {
                ((Server)this.getObject()).stop();
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Jetty '" + this.getName() + "' shutdown.");
                }
            }
        }
    }
}

