/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.expressions.EMode;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginTable;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.sql.IDataSourceProvider;
import org.specrunner.sql.PluginConnection;
import org.specrunner.sql.PluginDatabase;
import org.specrunner.sql.PluginSchema;
import org.specrunner.sql.database.DatabaseException;
import org.specrunner.sql.database.IDatabase;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.util.StringUtil;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.node.TableAdapter;

public abstract class AbstractPluginDatabase
extends AbstractPluginTable {
    public static final String FEATURE_SCHEMA = AbstractPluginDatabase.class.getName() + ".schema";
    private String schema;
    public static final String FEATURE_DATASOURCE = AbstractPluginDatabase.class.getName() + ".datasource";
    private String datasource;
    public static final String FEATURE_DATABASE = AbstractPluginDatabase.class.getName() + ".database";
    private String database;
    public static final String FEATURE_SEPARATOR = AbstractPluginDatabase.class.getName() + ".separator";
    public static final String DEFAULT_SEPARATOR = ";";
    private String separator = ";";
    private EMode mode;

    protected AbstractPluginDatabase(EMode mode) {
        this.mode = mode;
    }

    public String getDatasource() {
        return this.datasource;
    }

    @DontEval
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getSchema() {
        return this.schema;
    }

    @DontEval
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getDatabase() {
        return this.database;
    }

    @DontEval
    public void setDatabase(String database) {
        this.database = database;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public EMode getMode() {
        return this.mode;
    }

    public void setMode(EMode mode) {
        this.mode = mode;
    }

    public void initialize(IContext context, TableAdapter table) throws PluginException {
        super.initialize(context, table);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.schema == null) {
            fm.set(FEATURE_SCHEMA, (Object)this);
        }
        if (this.datasource == null) {
            fm.set(FEATURE_DATASOURCE, (Object)this);
        }
        if (this.database == null) {
            fm.set(FEATURE_DATABASE, (Object)this);
        }
        fm.set(FEATURE_SEPARATOR, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEnd(IContext context, IResultSet result, TableAdapter tableAdapter) throws PluginException {
        Schema schema = PluginSchema.getSchema(context, this.getSchema());
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug(((Object)((Object)this)).getClass().getSimpleName() + "     schema(" + this.getSchema() + "):" + schema);
        }
        String[] sources = StringUtil.tokenize(this.getDatasource() != null ? this.getDatasource() : "connectionName", this.separator);
        String[] bases = StringUtil.tokenize(this.getDatabase() != null ? this.getDatabase() : "databaseName", this.separator);
        int erros = 0;
        for (int i = 0; i < sources.length && i < bases.length; ++i) {
            String source = sources[i];
            String base = bases[i];
            IDataSourceProvider datasource = PluginConnection.getProvider(context, source);
            IDatabase database = PluginDatabase.getDatabase(context, base);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug(((Object)((Object)this)).getClass().getSimpleName() + " datasource(" + source + "):" + datasource);
                UtilLog.LOG.debug(((Object)((Object)this)).getClass().getSimpleName() + "   database(" + base + "):" + database);
            }
            DataSource ds = datasource.getDataSource();
            Connection connection = null;
            try {
                connection = ds.getConnection();
                if (UtilLog.LOG.isDebugEnabled()) {
                    DatabaseMetaData metaData = connection.getMetaData();
                    UtilLog.LOG.debug(((Object)((Object)this)).getClass().getSimpleName() + " connection:(" + metaData.getURL() + ")" + connection);
                }
                database.perform(context, result, tableAdapter, connection, schema, this.mode);
                continue;
            }
            catch (SQLException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                ++erros;
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Error in datasource: " + source + ", and database: " + base + ", and schema: " + schema.getAlias() + ". Error: " + e.getMessage(), (Throwable)e));
                continue;
            }
            catch (DatabaseException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)((Object)e));
                }
                ++erros;
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Error in datasource: " + source + ", and database: " + base + ", and schema: " + schema.getAlias() + ". Error: " + e.getMessage(), (Throwable)((Object)e)));
                continue;
            }
            finally {
                try {
                    if (connection != null) {
                        connection.commit();
                    }
                }
                catch (SQLException e) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    ++erros;
                    result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Error in datasource: " + source + ", and database: " + base + ", and schema: " + schema.getAlias() + ". Error: " + e.getMessage(), (Throwable)e));
                }
            }
        }
        if (erros == 0) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
    }
}

