/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.specrunner.SRServices;
import org.specrunner.comparators.ComparatorException;
import org.specrunner.comparators.IComparator;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.expressions.EMode;
import org.specrunner.expressions.INullEmptyFeature;
import org.specrunner.expressions.INullEmptyHandler;
import org.specrunner.expressions.core.NullEmptyHandlerDefault;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.sql.IDataSourceProvider;
import org.specrunner.sql.IResultEnumerator;
import org.specrunner.sql.PluginConnection;
import org.specrunner.sql.PluginFilter;
import org.specrunner.sql.PluginSchema;
import org.specrunner.sql.ResultSetEnumerator;
import org.specrunner.sql.database.IColumnReader;
import org.specrunner.sql.database.IDatabaseReader;
import org.specrunner.sql.database.impl.ColumnReaderDefault;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.IDataFilter;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.impl.DataFilterDefault;
import org.specrunner.sql.report.LineReport;
import org.specrunner.sql.report.RegisterType;
import org.specrunner.sql.report.ReportException;
import org.specrunner.sql.report.SchemaReport;
import org.specrunner.sql.report.TableReport;
import org.specrunner.util.UtilLog;

public class PluginCompareBase
extends AbstractPluginValue
implements INullEmptyFeature,
IDatabaseReader {
    public static final String FEATURE_SCHEMA = PluginCompareBase.class.getName() + ".schema";
    private String schema;
    public static final String FEATURE_SYSTEM = PluginCompareBase.class.getName() + ".system";
    private String system;
    public static final String FEATURE_REFERENCE = PluginCompareBase.class.getName() + ".reference";
    private String reference;
    public static final String FEATURE_FILTER = PluginCompareBase.class.getName() + ".filter";
    private String filter;
    protected INullEmptyHandler nullEmptyHandler = new NullEmptyHandlerDefault();
    protected IColumnReader columnReader = new ColumnReaderDefault();
    public static final String FEATURE_VIRTUAL = PluginCompareBase.class.getName() + ".virtual";
    private Boolean virtual;

    public String getSchema() {
        return this.schema;
    }

    @DontEval
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSystem() {
        return this.system;
    }

    @DontEval
    public void setSystem(String system) {
        this.system = system;
    }

    public String getReference() {
        return this.reference;
    }

    @DontEval
    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getFilter() {
        return this.filter;
    }

    @DontEval
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public INullEmptyHandler getNullEmptyHandler() {
        return this.nullEmptyHandler;
    }

    public void setNullEmptyHandler(INullEmptyHandler nullEmptyHandler) {
        this.nullEmptyHandler = nullEmptyHandler;
    }

    public IColumnReader getColumnReader() {
        return this.columnReader;
    }

    @Override
    public void setColumnReader(IColumnReader columnReader) {
        this.columnReader = columnReader;
    }

    public Boolean getVirtual() {
        return this.virtual;
    }

    public void setVirtual(Boolean virtual) {
        this.virtual = virtual;
    }

    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_SCHEMA, (Object)this);
        fm.set(FEATURE_SYSTEM, (Object)this);
        fm.set(FEATURE_REFERENCE, (Object)this);
        fm.set(INullEmptyFeature.FEATURE_NULL_EMPTY_HANDLER, (Object)this);
        fm.set(IDatabaseReader.FEATURE_COLUMN_READER, (Object)this);
        fm.set(FEATURE_FILTER, (Object)this);
        fm.set(FEATURE_VIRTUAL, (Object)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Schema schema = PluginSchema.getSchema(context, this.getSchema());
        IDataFilter currentFilter = null;
        currentFilter = this.getFilter() != null ? PluginFilter.getFilter(context, this.getFilter()) : new DataFilterDefault();
        currentFilter.setup(context, EMode.COMPARE, schema);
        if (!currentFilter.accept(EMode.COMPARE, schema)) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Schema ignored:" + schema.getAlias() + "(" + schema.getName() + ")");
            }
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
            return ENext.DEEP;
        }
        IDataSourceProvider expected = PluginConnection.getProvider(context, this.getReference());
        IDataSourceProvider received = PluginConnection.getProvider(context, this.getSystem());
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("     Schema provider:" + schema);
            UtilLog.LOG.debug("   Datasource system:" + received);
            UtilLog.LOG.debug("Datasource reference:" + expected);
        }
        DataSource dsExcepted = expected.getDataSource();
        DataSource dsReceived = received.getDataSource();
        Connection connectionExpected = null;
        Statement stmtExpected = null;
        Connection connectionReceived = null;
        Statement stmtReceived = null;
        SchemaReport report = new SchemaReport(schema);
        try {
            connectionExpected = dsExcepted.getConnection();
            stmtExpected = connectionExpected.createStatement();
            connectionReceived = dsReceived.getConnection();
            stmtReceived = connectionReceived.createStatement();
            if (UtilLog.LOG.isDebugEnabled()) {
                String simpleName = this.getClass().getSimpleName();
                UtilLog.LOG.debug((String)simpleName + " connection expected:" + connectionExpected);
                UtilLog.LOG.debug((String)simpleName + " connection received:" + connectionReceived);
                UtilLog.LOG.debug((String)simpleName + "  statement expected:" + stmtExpected);
                UtilLog.LOG.debug((String)simpleName + "  statement received:" + stmtReceived);
            }
            for (Table table : schema.getTables()) {
                if (!currentFilter.accept(EMode.COMPARE, table)) {
                    if (!UtilLog.LOG.isInfoEnabled()) continue;
                    UtilLog.LOG.info("Table ignored:" + table.getAlias() + "(" + table.getName() + ")");
                    continue;
                }
                String sql = this.createTableSelect(schema, table);
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Compare table (" + table.getName() + ", " + table.getAlias() + ") = " + sql);
                }
                ResultSet rsExpected = null;
                ResultSet rsReceived = null;
                try {
                    rsExpected = stmtExpected.executeQuery(sql);
                    rsReceived = stmtReceived.executeQuery(sql);
                    this.populateTableReport(schema, currentFilter, report, table, rsExpected, rsReceived);
                }
                catch (Exception e) {
                    if (!UtilLog.LOG.isDebugEnabled()) throw new PluginException((Throwable)e);
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    throw new PluginException((Throwable)e);
                }
                finally {
                    try {
                        if (rsExpected == null) continue;
                        rsExpected.close();
                    }
                    catch (Exception e) {
                        if (!UtilLog.LOG.isDebugEnabled()) throw new PluginException((Throwable)e);
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                        throw new PluginException((Throwable)e);
                    }
                    finally {
                        try {
                            if (rsReceived == null) continue;
                            rsReceived.close();
                        }
                        catch (Exception e) {
                            if (!UtilLog.LOG.isDebugEnabled()) throw new PluginException((Throwable)e);
                            UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            throw new PluginException((Throwable)e);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            if (!UtilLog.LOG.isDebugEnabled()) throw new PluginException((Throwable)e);
            UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            throw new PluginException((Throwable)e);
        }
        finally {
            try {
                if (stmtExpected != null) {
                    stmtExpected.close();
                }
            }
            catch (SQLException e) {
                if (!UtilLog.LOG.isDebugEnabled()) throw new PluginException((Throwable)e);
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                throw new PluginException((Throwable)e);
            }
            finally {
                try {
                    if (stmtReceived != null) {
                        stmtReceived.close();
                    }
                }
                catch (SQLException e) {
                    if (!UtilLog.LOG.isDebugEnabled()) throw new PluginException((Throwable)e);
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    throw new PluginException((Throwable)e);
                }
            }
        }
        if (!report.isEmpty()) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new ReportException(report));
            return ENext.DEEP;
        }
        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        return ENext.DEEP;
    }

    public String createTableSelect(Schema schema, Table table) {
        StringBuilder fields = new StringBuilder();
        StringBuilder keys = new StringBuilder();
        StringBuilder references = new StringBuilder();
        int indexFields = 0;
        int indexKeys = 0;
        int indexReferences = 0;
        for (Column c : table.getColumns()) {
            fields.append((indexFields++ > 0 ? "," : "") + c.getName());
            if (c.isKey()) {
                keys.append((indexKeys++ > 0 ? "," : "") + c.getName() + " asc");
            }
            if (!c.isReference()) continue;
            references.append((indexReferences++ > 0 ? "," : "") + c.getName() + " asc");
        }
        StringBuilder order = keys;
        if (this.virtual != null && this.virtual.booleanValue() && references.length() > 0) {
            order = references;
        }
        return "select " + fields + " from " + schema.getName() + "." + table.getName() + (order.length() > 0 ? " order by " + order : "");
    }

    public void populateTableReport(Schema schema, IDataFilter dataFilter, SchemaReport report, Table table, ResultSet rsExpected, ResultSet rsReceived) throws SQLException {
        IResultEnumerator comp = this.getEnumerator(table, rsExpected, rsReceived);
        TableReport tr = new TableReport(table);
        while (comp.next()) {
            Object read;
            ResultSet exp = comp.getExpected();
            ResultSet rec = comp.getReceived();
            LineReport lr = null;
            int index = 0;
            if (exp == null && rec != null) {
                lr = new LineReport(RegisterType.EXTRA, tr, this.nullEmptyHandler);
                for (Column c : table.getColumns()) {
                    if (!dataFilter.accept(EMode.COMPARE, c)) {
                        if (!UtilLog.LOG.isInfoEnabled()) continue;
                        UtilLog.LOG.info("Column ignored:" + c.getAlias() + "(" + c.getName() + ")");
                        continue;
                    }
                    read = this.columnReader.read(rec, c);
                    if (read == null) continue;
                    lr.add(c, index++, null, read);
                }
                if (lr.isEmpty()) continue;
                tr.add(lr);
                continue;
            }
            if (exp != null && rec == null) {
                lr = new LineReport(RegisterType.MISSING, tr, this.nullEmptyHandler);
                for (Column c : table.getColumns()) {
                    if (!dataFilter.accept(EMode.COMPARE, c)) {
                        if (!UtilLog.LOG.isInfoEnabled()) continue;
                        UtilLog.LOG.info("Column ignored:" + c.getAlias() + "(" + c.getName() + ")");
                        continue;
                    }
                    read = this.columnReader.read(exp, c);
                    if (read == null) continue;
                    lr.add(c, index++, read, null);
                }
                if (lr.isEmpty()) continue;
                tr.add(lr);
                continue;
            }
            lr = new LineReport(RegisterType.DIFFERENT, tr, this.nullEmptyHandler);
            for (Column c : table.getColumns()) {
                if (!dataFilter.accept(EMode.COMPARE, c)) {
                    if (!UtilLog.LOG.isInfoEnabled()) continue;
                    UtilLog.LOG.info("Column ignored:" + c.getAlias() + "(" + c.getName() + ")");
                    continue;
                }
                Object objExp = this.columnReader.read(exp, c);
                Object objRec = this.columnReader.read(rec, c);
                if (!dataFilter.accept(EMode.COMPARE, c, objRec)) {
                    if (!UtilLog.LOG.isInfoEnabled()) continue;
                    UtilLog.LOG.info("Value ignored(" + c.getAlias() + "," + c.getName() + "):" + objRec);
                    continue;
                }
                IComparator comparator = c.getComparator();
                comparator.initialize();
                try {
                    boolean match = comparator.match(objExp, objRec);
                    if (c.isKey() || match) continue;
                    lr.add(c, index++, objExp, objRec);
                }
                catch (ComparatorException e) {
                    throw new SQLException("Error on comparison of values.", e);
                }
            }
            if (lr.isEmpty()) continue;
            for (Column c : table.getKeys()) {
                lr.add(c, index++, this.columnReader.read(exp, c), this.columnReader.read(rec, c));
            }
            tr.add(lr);
        }
        if (!tr.isEmpty()) {
            report.add(tr);
        }
    }

    public IResultEnumerator getEnumerator(Table table, ResultSet rsExpected, ResultSet rsReceived) {
        return new ResultSetEnumerator(table, this.virtual, rsExpected, rsReceived);
    }
}

