/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.concurrency.IConcurrentMapping;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.sql.IDataSourceProvider;
import org.specrunner.sql.impl.SimpleDataSource;
import org.specrunner.util.UtilLog;

public class PluginConnection
extends AbstractPluginValue {
    public static final String DEFAULT_CONNECTION_NAME = "connectionName";
    public static final String FEATURE_CONNECTION = PluginConnection.class.getName() + ".connection";
    private String connection;
    public static final String FEATURE_SEPARATOR = PluginConnection.class.getName() + ".separator";
    public static final String DEFAULT_SEPARATOR = "|";
    private String separator = "|";
    public static final String FEATURE_DRIVER = PluginConnection.class.getName() + ".driver";
    private String driver;
    public static final String FEATURE_URL = PluginConnection.class.getName() + ".url";
    private String url;
    public static final String FEATURE_USER = PluginConnection.class.getName() + ".user";
    private String user;
    public static final String FEATURE_PASSWORD = PluginConnection.class.getName() + ".password";
    private String password;
    public static final String FEATURE_PROVIDER = PluginConnection.class.getName() + ".provider";
    private String provider;
    public static final String FEATURE_PROVIDER_INSTANCE = PluginConnection.class.getName() + ".providerInstance";
    private IDataSourceProvider providerInstance;
    public static final String FEATURE_REUSE = PluginConnection.class.getName() + ".reuse";
    private Boolean reuse = false;

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        int i;
        this.connection = connection;
        if (connection == null) {
            return;
        }
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        String other = this.separator + connection + this.separator;
        for (i = 0; i < other.length(); ++i) {
            if (other.charAt(i) != this.separator.charAt(0)) continue;
            indexes.add(i);
        }
        for (i = 0; i < indexes.size() - 1; ++i) {
            String tmp = connection.substring((Integer)indexes.get(i), (Integer)indexes.get(i + 1) - 1);
            if (this.driver == null) {
                this.setDriver(tmp);
                continue;
            }
            if (this.url == null) {
                this.setUrl(tmp);
                continue;
            }
            if (this.user == null) {
                this.setUser(tmp);
                continue;
            }
            if (this.password != null) continue;
            this.setPassword(tmp);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public IDataSourceProvider getProviderInstance() {
        return this.providerInstance;
    }

    public void setProviderInstance(IDataSourceProvider providerInstance) {
        this.providerInstance = providerInstance;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.connection == null) {
            fm.set(FEATURE_CONNECTION, (Object)this);
        }
        if (this.driver == null) {
            fm.set(FEATURE_DRIVER, (Object)this);
        }
        if (this.url == null) {
            fm.set(FEATURE_URL, (Object)this);
        }
        if (this.user == null) {
            fm.set(FEATURE_USER, (Object)this);
        }
        if (this.password == null) {
            fm.set(FEATURE_PASSWORD, (Object)this);
        }
        if (this.provider == null) {
            fm.set(FEATURE_PROVIDER, (Object)this);
        }
        fm.set(FEATURE_PROVIDER_INSTANCE, (Object)this);
        fm.set(FEATURE_REUSE, (Object)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        IReusable ir;
        final String currentName = this.getName() != null ? this.getName() : DEFAULT_CONNECTION_NAME;
        IReuseManager rm = (IReuseManager)SRServices.get(IReuseManager.class);
        if (this.reuse.booleanValue() && (ir = (IReusable)rm.get((Object)currentName)) != null) {
            HashMap<String, Object> cfg = new HashMap<String, Object>();
            cfg.put("name", currentName);
            cfg.put("connection", this.connection);
            cfg.put("provider", this.provider);
            cfg.put("providerInstance", this.providerInstance);
            cfg.put("driver", this.driver);
            cfg.put("url", this.url);
            cfg.put("user", this.user);
            cfg.put("password", this.password);
            if (ir.canReuse(cfg)) {
                ir.reset();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Reusing DataSource " + ir.getObject());
                }
                context.saveGlobal(currentName, ir.getObject());
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                return ENext.DEEP;
            }
        }
        if (this.providerInstance == null) {
            if (this.provider != null) {
                try {
                    this.providerInstance = (IDataSourceProvider)Class.forName(this.provider).newInstance();
                }
                catch (Exception e) {
                    throw new PluginException("Invalid IDataSourceProvider '" + this.provider + "'.", (Throwable)e);
                }
            } else {
                if (this.driver == null || this.url == null || this.user == null || this.password == null) throw new PluginException(((Object)((Object)this)).getClass().getSimpleName() + " must have a provider instance set using feature 'FEATURE_FILTER_INSTANCE', a generator of DataSource using feature 'FEATURE_FILTER', or connection information 'driver/url/user/password' passed as attributes or their specific 'FEATURE_...XXX' set.");
                this.providerInstance = this.createProvider();
            }
        } else if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Using instance " + this.providerInstance + ".");
        }
        if (this.reuse.booleanValue()) {
            rm.put((Object)currentName, (Object)new AbstractReusable<IDataSourceProvider>(currentName, this.providerInstance){

                public void reset() {
                }

                public void release() {
                    PluginConnection.this.providerInstance.release();
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Provider " + PluginConnection.this.providerInstance + " released.");
                    }
                }

                public boolean canReuse(Map<String, Object> cfg) {
                    boolean sameName = currentName.equalsIgnoreCase((String)cfg.get("name"));
                    boolean sameConnection = PluginConnection.this.connection != null && PluginConnection.this.connection.equals(cfg.get("connection"));
                    boolean sameProvider = PluginConnection.this.provider != null && PluginConnection.this.provider.equals(cfg.get("provider"));
                    boolean sameInstance = PluginConnection.this.providerInstance != null && PluginConnection.this.providerInstance == cfg.get("providerInstance");
                    boolean sameProperties = true;
                    sameProperties = PluginConnection.this.driver != null && PluginConnection.this.driver.equalsIgnoreCase((String)cfg.get("driver"));
                    sameProperties = sameProperties && PluginConnection.this.url != null && PluginConnection.this.url.equalsIgnoreCase((String)cfg.get("url"));
                    sameProperties = sameProperties && PluginConnection.this.user != null && PluginConnection.this.user.equalsIgnoreCase((String)cfg.get("user"));
                    sameProperties = sameProperties && PluginConnection.this.password != null && PluginConnection.this.password.equalsIgnoreCase((String)cfg.get("password"));
                    return sameName && (sameConnection || sameInstance || sameProvider || sameProperties);
                }
            });
        }
        context.saveGlobal(currentName, (Object)this.providerInstance);
        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        return ENext.DEEP;
    }

    public static synchronized IDataSourceProvider getProvider(IContext context, String name) throws PluginException {
        IDataSourceProvider provider;
        if (name == null) {
            name = DEFAULT_CONNECTION_NAME;
        }
        if ((provider = (IDataSourceProvider)context.getByName(name)) == null) {
            throw new PluginException("Instance of '" + IDataSourceProvider.class.getName() + "' named '" + name + "' not found. Use " + PluginConnection.class.getName() + " first.");
        }
        return provider;
    }

    public IDataSourceProvider createProvider() {
        String newUrl = this.url;
        if (this.getThreadsafe().booleanValue()) {
            IConcurrentMapping rm = (IConcurrentMapping)SRServices.get(IConcurrentMapping.class);
            newUrl = String.valueOf(rm.get("url", (Object)newUrl));
        }
        return new SimpleDataSource(this.driver, newUrl, this.user, this.password);
    }
}

