/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.sql.database.IDatabase;
import org.specrunner.sql.util.StringUtil;
import org.specrunner.util.UtilLog;

public class PluginDatabase
extends AbstractPluginValue {
    public static final String DEFAULT_DATABASE_NAME = "databaseName";
    public static final String FEATURE_PROVIDER = PluginDatabase.class.getName() + ".provider";
    private String provider;
    public static final String FEATURE_PROVIDER_INSTANCE = PluginDatabase.class.getName() + ".providerInstance";
    private IDatabase[] providerInstance;
    public static final String FEATURE_REUSE = PluginDatabase.class.getName() + ".reuse";
    private Boolean reuse = false;
    public static final String FEATURE_NAME = PluginDatabase.class.getName() + ".name";
    public static final String FEATURE_SEPARATOR = PluginDatabase.class.getName() + ".separator";
    public static final String DEFAULT_SEPARATOR = ";";
    private String separator = ";";

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public IDatabase[] getProviderInstance() {
        return this.providerInstance;
    }

    public void setProviderInstance(IDatabase[] providerInstance) {
        this.providerInstance = providerInstance == null ? null : Arrays.copyOf(providerInstance, providerInstance.length);
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.provider == null) {
            fm.set(FEATURE_PROVIDER, (Object)this);
        }
        fm.set(FEATURE_PROVIDER_INSTANCE, (Object)this);
        fm.set(FEATURE_REUSE, (Object)this);
        if (this.getName() == null) {
            fm.set(FEATURE_NAME, (Object)this);
        }
        fm.set(FEATURE_SEPARATOR, (Object)this);
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String[] bases = StringUtil.tokenize(this.getName() != null ? this.getName() : DEFAULT_DATABASE_NAME, this.separator);
        if (this.providerInstance == null) {
            this.providerInstance = new IDatabase[bases.length];
        }
        int failure = 0;
        int index = 0;
        String[] stringArray = bases;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            IReusable ir;
            String base;
            String currentName = base = stringArray[i];
            IReuseManager rm = (IReuseManager)SRServices.get(IReuseManager.class);
            if (this.reuse.booleanValue() && (ir = (IReusable)rm.get((Object)currentName)) != null) {
                HashMap<String, Object> cfg = new HashMap<String, Object>();
                cfg.put("provider", this.provider);
                cfg.put("providerInstance" + index, this.providerInstance[index]);
                if (ir.canReuse(cfg)) {
                    ir.reset();
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Reusing IDatabase(" + currentName + ") " + ir.getObject());
                    }
                    context.saveGlobal(currentName, ir.getObject());
                    result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                    return ENext.DEEP;
                }
            }
            if (this.providerInstance[index] == null) {
                if (this.provider != null) {
                    try {
                        this.providerInstance[index] = (IDatabase)Class.forName(this.provider).newInstance();
                    }
                    catch (Exception e) {
                        ++failure;
                        result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Invalid Database provider(" + index + ") '" + this.provider + "' for " + currentName + ". Error:" + e.getMessage(), (Throwable)e));
                    }
                }
            } else if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Using instance " + this.providerInstance[index] + ".");
            }
            if (this.providerInstance[index] != null) {
                this.providerInstance[index].initialize();
                this.providerInstance[index].setName(currentName);
            }
            if (this.reuse.booleanValue()) {
                final int indexInner = index;
                rm.put((Object)currentName, (Object)new AbstractReusable<IDatabase>(currentName, this.providerInstance[index]){

                    public void reset() {
                        PluginDatabase.this.providerInstance[indexInner].initialize();
                    }

                    public void release() {
                        block3: {
                            try {
                                PluginDatabase.this.providerInstance[indexInner].release();
                                if (UtilLog.LOG.isInfoEnabled()) {
                                    UtilLog.LOG.info("Provider " + PluginDatabase.this.providerInstance[indexInner] + " released.");
                                }
                            }
                            catch (PluginException e) {
                                if (!UtilLog.LOG.isDebugEnabled()) break block3;
                                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            }
                        }
                    }

                    public boolean canReuse(Map<String, Object> cfg) {
                        boolean sameProvider = PluginDatabase.this.provider != null && PluginDatabase.this.provider.equals(cfg.get("provider"));
                        boolean sameInstance = PluginDatabase.this.providerInstance[indexInner] == cfg.get("providerInstance" + indexInner);
                        return sameProvider || sameInstance;
                    }
                });
            }
            context.saveGlobal(currentName, (Object)this.providerInstance[index]);
            ++index;
        }
        if (failure == 0) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
        return ENext.DEEP;
    }

    public static synchronized IDatabase getDatabase(IContext context, String name) throws PluginException {
        IDatabase provider;
        if (name == null) {
            name = DEFAULT_DATABASE_NAME;
        }
        if ((provider = (IDatabase)context.getByName(name)) == null) {
            throw new PluginException("Instance of '" + IDatabase.class.getName() + "' named '" + name + "' not found. Use " + PluginDatabase.class.getName() + " first.");
        }
        return provider;
    }
}

