/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.sql.meta.IDataFilter;
import org.specrunner.util.UtilLog;

public class PluginFilter
extends AbstractPluginValue {
    public static final String DEFAULT_FILTER_NAME = "filterName";
    public static final String FEATURE_FILTER = PluginFilter.class.getName() + ".provider";
    private String provider;
    public static final String FEATURE_FILTER_INSTANCE = PluginFilter.class.getName() + ".providerInstance";
    private IDataFilter providerInstance;
    public static final String FEATURE_REUSE = PluginFilter.class.getName() + ".reuse";
    private Boolean reuse = false;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public IDataFilter getProviderInstance() {
        return this.providerInstance;
    }

    public void setProviderInstance(IDataFilter providerInstance) {
        this.providerInstance = providerInstance;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.provider == null) {
            fm.set(FEATURE_FILTER, (Object)this);
        }
        fm.set(FEATURE_FILTER_INSTANCE, (Object)this);
        fm.set(FEATURE_REUSE, (Object)this);
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        IReusable ir;
        final String currentName = this.getName() != null ? this.getName() : DEFAULT_FILTER_NAME;
        IReuseManager rm = (IReuseManager)SRServices.get(IReuseManager.class);
        if (this.reuse.booleanValue() && (ir = (IReusable)rm.get((Object)currentName)) != null) {
            HashMap<String, Object> cfg = new HashMap<String, Object>();
            cfg.put("name", currentName);
            cfg.put("provider", this.provider);
            cfg.put("providerInstance", this.providerInstance);
            if (ir.canReuse(cfg)) {
                ir.reset();
                Object obj = ir.getObject();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Reusing Filter " + obj);
                }
                context.saveGlobal(currentName, obj);
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                return ENext.DEEP;
            }
        }
        if (this.providerInstance == null) {
            if (this.provider != null) {
                try {
                    this.providerInstance = (IDataFilter)Class.forName(this.provider).newInstance();
                }
                catch (Exception e) {
                    throw new PluginException("Invalid IFilter provider '" + this.provider + "'.", (Throwable)e);
                }
            }
        } else if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Using instance " + this.providerInstance + ".");
        }
        if (this.reuse.booleanValue()) {
            rm.put((Object)currentName, (Object)new AbstractReusable<IDataFilter>(currentName, this.providerInstance){

                public void reset() {
                }

                public void release() {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Provider " + PluginFilter.this.providerInstance + " released.");
                    }
                }

                public boolean canReuse(Map<String, Object> cfg) {
                    boolean sameName = currentName != null && PluginFilter.this.provider.equals(cfg.get("name"));
                    boolean sameProvider = PluginFilter.this.provider != null && PluginFilter.this.provider.equals(cfg.get("provider"));
                    boolean sameInstance = PluginFilter.this.providerInstance != null && PluginFilter.this.providerInstance == cfg.get("providerInstance");
                    return sameName && (sameProvider || sameInstance);
                }
            });
        }
        context.saveGlobal(currentName, (Object)this.providerInstance);
        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        return ENext.DEEP;
    }

    public static IDataFilter getFilter(IContext context, String name) throws PluginException {
        IDataFilter provider;
        if (name == null) {
            name = DEFAULT_FILTER_NAME;
        }
        if ((provider = (IDataFilter)context.getByName(name)) == null) {
            throw new PluginException("Instance of '" + IDataFilter.class.getName() + "' named '" + name + "' not found. Use " + PluginFilter.class.getName() + " first.");
        }
        return provider;
    }
}

