/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.IPluginFactory;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPlugin;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.util.xom.node.CellAdapter;
import org.specrunner.util.xom.node.TableAdapter;
import org.specrunner.util.xom.node.UtilTable;

public class PluginJoined
extends AbstractPlugin {
    public static final String ATTR_SPAN = "span";
    public static final String ATTR_CAPTION = "caption";
    public static final String ATTR_ACTION = "action";
    public boolean reverse = false;

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Node node = context.getNode();
        ParentNode parent = node.getParent();
        int index = parent.indexOf(node);
        TableAdapter table = UtilTable.newTable((Node)node);
        int colIndex = 0;
        int fixed = 0;
        int columnIndex = 0;
        Element quote = new Element("blockquote");
        Element included = new Element("table");
        quote.appendChild((Node)included);
        Element tr = new Element("tr");
        included.appendChild((Node)tr);
        Element td = new Element("td");
        tr.appendChild((Node)td);
        UtilNode.appendCss((Node)included, (String)"included");
        for (CellAdapter c : table.getCols()) {
            int span = Integer.parseInt(c.getAttribute(ATTR_SPAN, "1"));
            if (colIndex == 0) {
                if (span < 1) {
                    throw new PluginException("First column must specify the number of fixed columns, which should be equals or greater than 1,  if 'action' attribute is not part of table (one column for Action type and the others like ID should be repeated), or greater or equals to 1.");
                }
                fixed = span;
                ++colIndex;
                columnIndex += span;
                continue;
            }
            TableAdapter copy = UtilTable.newTable((Node)node.copy());
            String alias = ((IPluginFactory)SRServices.get(IPluginFactory.class)).getAlias(PluginJoined.class);
            copy.setAttribute("class", table.getAttribute("class").replace(alias, ""));
            if (colIndex < table.getColsCount() - 1 && !c.hasAttribute(ATTR_CAPTION)) {
                throw new PluginException("Colgroup item (" + colIndex + ") '" + c.toXML() + "' missing caption attribute. Caption is used to define the expanded table column name. i.e. caption=\"Customers\"");
            }
            if (c.hasAttribute(ATTR_CAPTION)) {
                if (!copy.getCaptions().isEmpty()) {
                    copy.getCaption(0).setValue(c.getAttribute(ATTR_CAPTION));
                } else {
                    copy.setAttribute(ATTR_CAPTION, c.getAttribute(ATTR_CAPTION));
                }
            }
            if (c.hasAttribute(ATTR_ACTION)) {
                copy.setAttribute(ATTR_ACTION, c.getAttribute(ATTR_ACTION));
            } else {
                Element e = (Element)c.getNode().getParent();
                if (e.getAttribute(ATTR_ACTION) != null) {
                    copy.setAttribute(ATTR_ACTION, e.getAttributeValue(ATTR_ACTION));
                } else if (table.hasAttribute(ATTR_ACTION)) {
                    copy.setAttribute(ATTR_ACTION, table.getAttribute(ATTR_ACTION));
                }
            }
            if (this.reverse) {
                td.insertChild(copy.getNode(), 0);
            } else {
                td.appendChild(copy.getNode());
            }
            copy.select(fixed - 1, colIndex, columnIndex, span);
            ++colIndex;
            columnIndex += span;
        }
        parent.insertChild((Node)quote, index + 1);
        UtilNode.setIgnore((Node)node);
        return ENext.SKIP;
    }
}

