/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.sql.PluginDatabase;
import org.specrunner.sql.database.IDatabase;
import org.specrunner.sql.util.StringUtil;
import org.specrunner.util.UtilLog;

public class PluginRelease
extends AbstractPluginValue {
    public static final String FEATURE_NAME = PluginRelease.class.getName() + ".name";
    public static final String FEATURE_SEPARATOR = PluginRelease.class.getName() + ".separator";
    public static final String DEFAULT_SEPARATOR = ";";
    private String separator = ";";

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.getName() == null) {
            fm.set(FEATURE_NAME, (Object)this);
        }
        fm.set(FEATURE_SEPARATOR, (Object)this);
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String[] bases = StringUtil.tokenize(this.getName() != null ? this.getName() : "databaseName", this.separator);
        int failure = 0;
        for (String base : bases) {
            IDatabase database = PluginDatabase.getDatabase(context, base);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("PluginRelease database:" + database);
            }
            try {
                if (((IReuseManager)SRServices.get(IReuseManager.class)).get((Object)base) == null) {
                    database.release();
                    continue;
                }
                if (!UtilLog.LOG.isDebugEnabled()) continue;
                UtilLog.LOG.debug("PluginRelease reusable database:" + base + " not release.");
            }
            catch (Exception e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                ++failure;
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Error in database:" + base + ". Error:" + e.getMessage(), (Throwable)e));
            }
        }
        if (failure == 0) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
        return ENext.DEEP;
    }
}

