/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.sql.PluginSchemaLoader;
import org.specrunner.sql.meta.ISchemaLoader;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.SchemaException;
import org.specrunner.util.UtilLog;

public class PluginSchema
extends AbstractPluginValue {
    public static final String DEFAULT_SCHEMA_NAME = "schemaName";
    public static final String FEATURE_PROVIDER_INSTANCE = PluginSchema.class.getName() + ".providerInstance";
    private Schema providerInstance;
    public static final String FEATURE_SOURCE = PluginSchema.class.getName() + ".source";
    private Object source;
    public static final String FEATURE_REUSE = PluginSchemaLoader.class.getName() + ".reuse";
    private Boolean reuse = false;

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.providerInstance == null) {
            fm.set(FEATURE_PROVIDER_INSTANCE, (Object)this);
        }
        fm.set(FEATURE_SOURCE, (Object)this);
        fm.set(FEATURE_REUSE, (Object)this);
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        IReusable ir;
        ISchemaLoader provider = PluginSchemaLoader.getLoader(context, this.getName());
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("PluginSchema loader:" + provider);
        }
        String currentName = this.getName() != null ? this.getName() : DEFAULT_SCHEMA_NAME;
        IReuseManager rm = (IReuseManager)SRServices.get(IReuseManager.class);
        if (this.reuse.booleanValue() && (ir = (IReusable)rm.get((Object)currentName)) != null) {
            HashMap<String, Object> cfg = new HashMap<String, Object>();
            cfg.put("source", this.source);
            cfg.put("providerInstance", this.providerInstance);
            if (ir.canReuse(cfg)) {
                ((SchemaReusable)ir).current = context;
                ir.reset();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Reusing Schema " + ir.getObject());
                }
                context.saveGlobal(currentName, ir.getObject());
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                return ENext.DEEP;
            }
        }
        if (this.providerInstance == null) {
            if (provider != null) {
                try {
                    this.providerInstance = provider.load(context, this.source);
                }
                catch (SchemaException e) {
                    throw new PluginException((Throwable)((Object)e));
                }
            }
        } else if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Using instance " + this.providerInstance + ".");
        }
        if (this.reuse.booleanValue()) {
            rm.put((Object)currentName, (Object)new SchemaReusable(currentName, this.providerInstance));
        }
        context.saveGlobal(currentName, (Object)this.providerInstance);
        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        return ENext.DEEP;
    }

    public static synchronized Schema getSchema(IContext context, String name) throws PluginException {
        Schema provider;
        if (name == null) {
            name = DEFAULT_SCHEMA_NAME;
        }
        if ((provider = (Schema)context.getByName(name)) == null) {
            throw new PluginException("Instance of '" + Schema.class.getName() + "' named '" + name + "' not found. Use " + PluginSchema.class.getName() + " first.");
        }
        return provider;
    }

    public class SchemaReusable
    extends AbstractReusable<Schema> {
        private IContext old;
        private IContext current;

        public SchemaReusable(String name, Schema schema) {
            super(name, (Object)schema);
        }

        public void reset() {
            if (this.old != this.current) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Provider " + PluginSchema.this.providerInstance + " initialization.");
                }
                PluginSchema.this.providerInstance.initialize(this.current);
            } else if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Provider " + PluginSchema.this.providerInstance + " ready to use.");
            }
            this.old = this.current;
        }

        public void release() {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Provider " + PluginSchema.this.providerInstance + " released.");
            }
        }

        public boolean canReuse(Map<String, Object> cfg) {
            boolean sameSource = PluginSchema.this.source != null && PluginSchema.this.source.equals(cfg.get("source"));
            boolean sameInstance = PluginSchema.this.providerInstance != null && PluginSchema.this.providerInstance == cfg.get("providerInstance");
            return sameSource || sameInstance;
        }
    }
}

