/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.sql.meta.ISchemaLoader;
import org.specrunner.util.UtilLog;

public class PluginSchemaLoader
extends AbstractPluginValue {
    public static final String DEFAULT_SCHEMALOADER_NAME = "schemaLoaderName";
    public static final String FEATURE_PROVIDER = PluginSchemaLoader.class.getName() + ".provider";
    private String provider;
    public static final String FEATURE_PROVIDER_INSTANCE = PluginSchemaLoader.class.getName() + ".providerInstance";
    private ISchemaLoader providerInstance;
    public static final String FEATURE_REUSE = PluginSchemaLoader.class.getName() + ".reuse";
    private Boolean reuse = false;

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ISchemaLoader getProviderInstance() {
        return this.providerInstance;
    }

    public void setProviderInstance(ISchemaLoader providerInstance) {
        this.providerInstance = providerInstance;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.provider == null) {
            fm.set(FEATURE_PROVIDER, (Object)this);
        }
        fm.set(FEATURE_PROVIDER_INSTANCE, (Object)this);
        fm.set(FEATURE_REUSE, (Object)this);
    }

    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        IReusable ir;
        String currentName = this.getName() != null ? this.getName() : DEFAULT_SCHEMALOADER_NAME;
        IReuseManager rm = (IReuseManager)SRServices.get(IReuseManager.class);
        if (this.reuse.booleanValue() && (ir = (IReusable)rm.get((Object)currentName)) != null) {
            HashMap<String, Object> cfg = new HashMap<String, Object>();
            cfg.put("provider", this.provider);
            cfg.put("providerInstance", this.providerInstance);
            if (ir.canReuse(cfg)) {
                ir.reset();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Reusing ISchemaLoader " + ir.getObject());
                }
                context.saveGlobal(currentName, ir.getObject());
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                return ENext.DEEP;
            }
        }
        if (this.providerInstance == null) {
            if (this.provider != null) {
                try {
                    this.providerInstance = (ISchemaLoader)Class.forName(this.provider).newInstance();
                }
                catch (Exception e) {
                    throw new PluginException("Invalid ISchemaLoader provider '" + this.provider + "'.", (Throwable)e);
                }
            }
        } else if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("Using instance " + this.providerInstance + ".");
        }
        if (this.reuse.booleanValue()) {
            rm.put((Object)currentName, (Object)new AbstractReusable<ISchemaLoader>(currentName, this.providerInstance){

                public void reset() {
                }

                public void release() {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("Provider " + PluginSchemaLoader.this.providerInstance + " released.");
                    }
                }

                public boolean canReuse(Map<String, Object> cfg) {
                    boolean sameProvider = PluginSchemaLoader.this.provider != null && PluginSchemaLoader.this.provider.equals(cfg.get("provider"));
                    boolean sameInstance = PluginSchemaLoader.this.providerInstance != null && PluginSchemaLoader.this.providerInstance == cfg.get("providerInstance");
                    return sameProvider || sameInstance;
                }
            });
        }
        context.saveGlobal(currentName, (Object)this.providerInstance);
        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        return ENext.DEEP;
    }

    public static synchronized ISchemaLoader getLoader(IContext context, String name) throws PluginException {
        ISchemaLoader provider;
        if (name == null) {
            name = DEFAULT_SCHEMALOADER_NAME;
        }
        if ((provider = (ISchemaLoader)context.getByName(name)) == null) {
            throw new PluginException("Instance of '" + ISchemaLoader.class.getName() + "' named '" + name + "' not found. Use " + PluginSchemaLoader.class.getName() + " first.");
        }
        return provider;
    }
}

