/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import nu.xom.Attribute;
import nu.xom.Element;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.plugins.type.Command;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.result.status.Warning;
import org.specrunner.source.ISource;
import org.specrunner.sql.IDataSourceProvider;
import org.specrunner.sql.PluginConnection;
import org.specrunner.sql.util.StringUtil;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;
import org.specrunner.util.expression.UtilExpression;

public class PluginScripts
extends AbstractPluginValue {
    protected static ThreadLocal<ICache<String, String>> cache = new ThreadLocal<ICache<String, String>>(){

        @Override
        protected ICache<String, String> initialValue() {
            return ((ICacheFactory)SRServices.get(ICacheFactory.class)).newCache(PluginScripts.class.getName());
        }
    };
    public static final String FEATURE_SCRIPT_SEPARATOR = PluginScripts.class.getName() + ".scriptseparator";
    private String scriptseparator = ";";
    private URI[] scripts;
    public static final String FEATURE_SQL_SEPARATOR = PluginScripts.class.getName() + ".sqlseparator";
    private String sqlseparator = ";";
    public static final String FEATURE_NAME_SEPARATOR = PluginScripts.class.getName() + ".separator";
    public static final String DEFAULT_NAME_SEPARATOR = ";";
    private String nameseparator = ";";
    public static final String FEATURE_CLASSPATH_RELATIVE = PluginScripts.class.getName() + ".classpath";
    public static final boolean DEFAULT_CLASSPATH_RELATIVE = false;
    private boolean classpathrelative = false;
    public static final String FEATURE_FAILSAFE = PluginScripts.class.getName() + ".failsafe";
    private Boolean failsafe = false;

    public URI[] getScripts() {
        return this.scripts;
    }

    public void setScripts(URI[] scripts) {
        this.scripts = scripts == null ? null : Arrays.copyOf(scripts, scripts.length);
    }

    public String getScriptseparator() {
        return this.scriptseparator;
    }

    public void setScriptseparator(String scriptseparator) {
        this.scriptseparator = scriptseparator;
    }

    public String getSqlseparator() {
        return this.sqlseparator;
    }

    public void setSqlseparator(String sqlseparator) {
        this.sqlseparator = sqlseparator;
    }

    public String getNameseparator() {
        return this.nameseparator;
    }

    public void setNameseparator(String nameseparator) {
        this.nameseparator = nameseparator;
    }

    public boolean isClasspathrelative() {
        return this.classpathrelative;
    }

    public void setClasspathrelative(boolean classpathrelative) {
        this.classpathrelative = classpathrelative;
    }

    public Boolean getFailsafe() {
        return this.failsafe;
    }

    public void setFailsafe(Boolean failsafe) {
        this.failsafe = failsafe;
    }

    public ActionType getActionType() {
        return Command.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_SCRIPT_SEPARATOR, (Object)this);
        fm.set(FEATURE_SQL_SEPARATOR, (Object)this);
        fm.set(FEATURE_NAME_SEPARATOR, (Object)this);
        fm.set(FEATURE_CLASSPATH_RELATIVE, (Object)this);
        fm.set(FEATURE_FAILSAFE, (Object)this);
        this.setScripts(context);
    }

    protected void setScripts(IContext context) throws PluginException {
        if (this.scripts == null) {
            Object tmp = this.getValue(this.getValue() != null ? this.getValue() : context.getNode().getValue(), true, context);
            String value = String.valueOf(tmp);
            StringTokenizer st = new StringTokenizer(value, this.scriptseparator);
            LinkedList<URI> list = new LinkedList<URI>();
            ISource source = context.getCurrentSource();
            URI base = source.getURI();
            while (st.hasMoreTokens()) {
                String val = st.nextToken().trim();
                if (val.isEmpty()) continue;
                URI f = null;
                if (this.classpathrelative) {
                    try {
                        URL resource = PluginScripts.class.getResource(val);
                        if (resource == null) {
                            throw new PluginException("Resource '" + val + "' not found on classpath.");
                        }
                        f = resource.toURI();
                    }
                    catch (URISyntaxException e) {
                        String msg = "Could not find: " + val;
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug(msg);
                        }
                        throw new PluginException(msg, (Throwable)e);
                    }
                } else {
                    f = base.resolve(val);
                }
                list.add(f);
                if (!UtilLog.LOG.isInfoEnabled()) continue;
                UtilLog.LOG.info("PluginScript scheduled:" + f);
            }
            this.scripts = list.toArray(new URI[list.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        String[] sources = StringUtil.tokenize(this.getName() != null ? this.getName() : "connectionName", this.nameseparator);
        int failure = 0;
        for (String source : sources) {
            IDataSourceProvider provider = PluginConnection.getProvider(context, source);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("PluginScript provider:" + provider);
            }
            DataSource ds = provider.getDataSource();
            Connection connection = null;
            try {
                connection = ds.getConnection();
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("PluginScript connection:" + connection);
                }
                for (URI u : this.scripts) {
                    void var16_19;
                    boolean fromCache;
                    String str;
                    block34: {
                        block36: {
                            block35: {
                                Object var16_20 = null;
                                str = u.toString();
                                String script = (String)cache.get().get((Object)str);
                                boolean bl = fromCache = script != null;
                                if (!fromCache) break block35;
                                StringReader stringReader = new StringReader(script);
                                if (UtilLog.LOG.isDebugEnabled()) {
                                    UtilLog.LOG.debug("Script " + str + " reused.");
                                }
                                break block34;
                            }
                            if (str == null || !str.startsWith("file:")) break block36;
                            try {
                                URI uri = new URI(str);
                                str = new File(uri).toString();
                            }
                            catch (URISyntaxException e) {
                                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Invalid script reference:" + str + "."));
                                ++failure;
                                continue;
                            }
                            File f = new File(str);
                            if (!f.exists()) {
                                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Script:" + f + " not found."));
                                ++failure;
                                break block34;
                            } else {
                                IBlock block = (IBlock)context.peek();
                                if (block.getNode() instanceof Element) {
                                    Element old = (Element)block.getNode();
                                    old.addAttribute(new Attribute("href", String.valueOf(f.toURI())));
                                }
                                try {
                                    FileReader fileReader = new FileReader(f);
                                }
                                catch (FileNotFoundException e) {
                                    if (UtilLog.LOG.isDebugEnabled()) {
                                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                                    }
                                    break block34;
                                }
                            }
                        }
                        try {
                            URL url = u.toURL();
                            URLConnection con = url.openConnection();
                            InputStreamReader inputStreamReader = new InputStreamReader(con.getInputStream());
                        }
                        catch (MalformedURLException e) {
                            if (UtilLog.LOG.isDebugEnabled()) {
                                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            }
                            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)e);
                            ++failure;
                        }
                        catch (IOException e) {
                            if (UtilLog.LOG.isDebugEnabled()) {
                                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                            }
                            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)e);
                            ++failure;
                        }
                    }
                    if (var16_19 == null) continue;
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("PluginScript perform:" + u);
                    }
                    failure += this.perform(context, result, connection, str, (Reader)var16_19, fromCache);
                }
            }
            catch (SQLException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                ++failure;
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Error in connection:" + source + ". Error:" + e.getMessage(), (Throwable)e));
            }
            finally {
                try {
                    if (connection != null) {
                        connection.commit();
                    }
                }
                catch (SQLException e) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Error in connection:" + source + ". Error:" + e.getMessage(), (Throwable)e));
                }
            }
        }
        if (failure == 0) {
            result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
        }
        return ENext.DEEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int perform(IContext context, IResultSet result, Connection connection, String reference, Reader script, boolean fromCache) throws SQLException {
        int failures = 0;
        Statement stmt = null;
        BufferedReader br = null;
        try {
            stmt = connection.createStatement();
            try {
                String sql;
                StringBuilder command = new StringBuilder();
                StringBuilder full = new StringBuilder();
                br = new BufferedReader(script);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).endsWith(this.sqlseparator)) {
                        command.append(" ");
                        command.append(line.substring(0, line.length() - 1));
                        line = "";
                    }
                    if (line.isEmpty() || line.startsWith("--")) {
                        if (command.length() <= 0) continue;
                        sql = command.toString();
                        failures += this.execute(stmt, sql, context, result);
                        if (!fromCache) {
                            full.append(sql);
                            full.append("\n\n");
                        }
                        command.setLength(0);
                        continue;
                    }
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Command  before: " + line);
                    }
                    line = UtilExpression.replace((String)line, (IContext)context, (boolean)true);
                    if (UtilLog.LOG.isTraceEnabled()) {
                        UtilLog.LOG.trace("Command   after: " + line);
                    }
                    command.append(" " + line);
                }
                if (command.length() > 0) {
                    sql = command.toString();
                    failures += this.execute(stmt, sql, context, result);
                    if (!fromCache) {
                        full.append(sql);
                        full.append("\n\n");
                    }
                }
                if (!fromCache) {
                    cache.get().put((Object)reference, (Object)full.toString());
                }
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Script '" + reference + "' added to cache '" + cache.get().getName() + "'.");
                }
            }
            catch (Exception e) {
                ++failures;
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)e);
            }
            finally {
                block33: {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            if (!UtilLog.LOG.isDebugEnabled()) break block33;
                            UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        finally {
            block34: {
                if (stmt != null) {
                    stmt.close();
                }
                if (script != null) {
                    try {
                        script.close();
                    }
                    catch (IOException e) {
                        if (!UtilLog.LOG.isDebugEnabled()) break block34;
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return failures;
    }

    protected int execute(Statement stmt, String sql, IContext context, IResultSet result) {
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Command execute: " + sql);
        }
        try {
            stmt.executeUpdate(sql);
            return 0;
        }
        catch (SQLException e) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Command   error: " + e.getMessage());
            }
            if (!this.failsafe.booleanValue()) {
                result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)e);
                return 1;
            }
            result.addResult((Status)Warning.INSTANCE, (IBlock)context.peek(), (Throwable)e);
            return 0;
        }
    }
}

