/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.specrunner.sql.IResultEnumerator;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.Table;

public class ResultSetEnumerator
implements IResultEnumerator {
    private Table table;
    private Boolean virtual;
    private ResultSet rsExpected;
    private ResultSet rsReceived;
    private boolean consumeExpected = true;
    private boolean consumeReceived = true;
    private boolean hasExpected = false;
    private boolean hasReceived = false;
    private boolean readExpected = false;
    private boolean readReceived = false;

    public ResultSetEnumerator(Table table, Boolean virtual, ResultSet expected, ResultSet received) {
        this.table = table;
        this.virtual = virtual;
        this.rsExpected = expected;
        this.rsReceived = received;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.consumeExpected) {
            this.hasExpected = this.rsExpected.next();
        }
        if (this.consumeReceived) {
            this.hasReceived = this.rsReceived.next();
        }
        if (this.hasExpected && this.hasReceived) {
            int comp = 0;
            Iterator<Column> columns = (this.virtual != null && this.virtual != false ? this.table.getReferences() : this.table.getKeys()).iterator();
            while (columns.hasNext() && comp == 0) {
                Column c = columns.next();
                Object tExp = this.rsExpected.getObject(c.getName());
                Object tRec = this.rsReceived.getObject(c.getName());
                comp = c.getComparator().compare(tExp, tRec);
            }
            if (comp < 0) {
                this.readExpected = true;
                this.readReceived = false;
            } else if (comp > 0) {
                this.readExpected = false;
                this.readReceived = true;
            } else {
                this.readExpected = true;
                this.readReceived = true;
            }
        } else if (this.hasExpected && !this.hasReceived) {
            this.readExpected = true;
            this.readReceived = false;
        } else if (!this.hasExpected && this.hasReceived) {
            this.readExpected = false;
            this.readReceived = true;
        }
        return this.readExpected || this.readReceived;
    }

    @Override
    public ResultSet getExpected() {
        ResultSet t = this.readExpected ? this.rsExpected : null;
        this.consumeExpected = this.readExpected;
        this.readExpected = false;
        return t;
    }

    @Override
    public ResultSet getReceived() {
        ResultSet t = this.readReceived ? this.rsReceived : null;
        this.consumeReceived = this.readReceived;
        this.readReceived = false;
        return t;
    }
}

