/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database;

import java.util.Map;
import org.specrunner.sql.database.CommandType;

public class SqlWrapper {
    private CommandType type;
    private String sql;
    private Map<String, Integer> namesToIndexes;
    private int expectedCount;
    private static final ThreadLocal<SqlWrapper> INSERT = new ThreadLocal<SqlWrapper>(){

        @Override
        protected SqlWrapper initialValue() {
            return new SqlWrapper(CommandType.INSERT);
        }
    };
    private static final ThreadLocal<SqlWrapper> UPDATE = new ThreadLocal<SqlWrapper>(){

        @Override
        protected SqlWrapper initialValue() {
            return new SqlWrapper(CommandType.UPDATE);
        }
    };
    private static final ThreadLocal<SqlWrapper> DELETE = new ThreadLocal<SqlWrapper>(){

        @Override
        protected SqlWrapper initialValue() {
            return new SqlWrapper(CommandType.DELETE);
        }
    };

    protected SqlWrapper(CommandType type) {
        this.type = type;
    }

    public CommandType getType() {
        return this.type;
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, Integer> getNamesToIndexes() {
        return this.namesToIndexes;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public static SqlWrapper insert(String sql, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.prepare(INSERT.get(), sql, namesToIndexes, expectedCount);
    }

    public static SqlWrapper update(String sql, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.prepare(UPDATE.get(), sql, namesToIndexes, expectedCount);
    }

    public static SqlWrapper delete(String sql, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.prepare(DELETE.get(), sql, namesToIndexes, expectedCount);
    }

    public static SqlWrapper newWrapper(CommandType type, String sql, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.prepare(new SqlWrapper(type), sql, namesToIndexes, expectedCount);
    }

    protected static SqlWrapper prepare(SqlWrapper type, String sql, Map<String, Integer> namesToIndexes, int expectedCount) {
        type.sql = sql;
        type.namesToIndexes = namesToIndexes;
        type.expectedCount = expectedCount;
        return type;
    }
}

