/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.specrunner.expressions.EMode;
import org.specrunner.sql.database.CommandType;
import org.specrunner.sql.database.DatabaseException;
import org.specrunner.sql.database.DatabaseRegisterEvent;
import org.specrunner.sql.database.DatabaseTableEvent;
import org.specrunner.sql.database.IDatabaseListener;
import org.specrunner.sql.meta.Table;

public class DatabaseCountListener
implements IDatabaseListener {
    private Map<String, Integer> countersIn = new HashMap<String, Integer>();
    private Map<String, Integer> countersOut = new HashMap<String, Integer>();

    public void initialize() {
    }

    @Override
    public void onTableIn(DatabaseTableEvent event) throws DatabaseException {
    }

    @Override
    public void onRegisterIn(DatabaseRegisterEvent event) {
        String name = event.getTable().getName();
        CommandType type = event.getWrapper().getType();
        int count = event.getWrapper().getExpectedCount();
        Integer old = this.countersIn.get(name);
        if (old == null) {
            old = 0;
        }
        if (CommandType.INSERT == type) {
            old = old + count;
        } else if (CommandType.DELETE == type) {
            old = count == Integer.MAX_VALUE ? Integer.valueOf(0) : Integer.valueOf(old - count);
        }
        this.countersIn.put(name, old);
    }

    @Override
    public void onRegisterOut(DatabaseRegisterEvent event) {
        String name = event.getTable().getName();
        CommandType type = event.getWrapper().getType();
        int count = CommandType.DELETE == type ? 1 : event.getWrapper().getExpectedCount();
        Integer old = this.countersOut.get(name);
        if (old == null) {
            old = 0;
        }
        if (CommandType.INSERT == type) {
            old = old + count;
        } else if (CommandType.DELETE == type) {
            old = old - count;
        }
        this.countersOut.put(name, old);
    }

    @Override
    public void onTableOut(DatabaseTableEvent event) throws DatabaseException {
        if (event.getMode() == EMode.OUTPUT) {
            Integer out;
            String name = event.getTable().getName();
            Integer in = this.countersIn.get(name);
            if (in == null) {
                in = 0;
            }
            if ((out = this.countersOut.get(name)) == null) {
                out = 0;
            }
            this.checkCount(event.getConnection(), event.getTable(), in + out);
        }
    }

    protected void checkCount(Connection con, Table table, int rows) throws DatabaseException {
        block17: {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                String alias = table.getParent().getName() + "." + table.getName();
                rs = stmt.executeQuery("select count(*) from " + alias);
                if (rs.next()) {
                    int expected;
                    int received = rs.getInt(1);
                    if (received != (expected = rows)) {
                        throw new DatabaseException("The number of elements present in table '" + alias + "' is " + received + ", expected was " + expected);
                    }
                    break block17;
                }
                throw new DatabaseException("Could not count rows for table '" + alias + "'.");
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
            }
        }
    }
}

