/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.SRServices;
import org.specrunner.comparators.ComparatorException;
import org.specrunner.comparators.IComparator;
import org.specrunner.comparators.core.ComparatorDate;
import org.specrunner.context.IContext;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.IConverter;
import org.specrunner.converters.IConverterReverse;
import org.specrunner.expressions.EMode;
import org.specrunner.expressions.INullEmptyHandler;
import org.specrunner.expressions.core.NullEmptyHandlerDefault;
import org.specrunner.features.IFeatureManager;
import org.specrunner.formatters.FormatterException;
import org.specrunner.formatters.IFormatter;
import org.specrunner.parameters.DontEval;
import org.specrunner.plugins.PluginException;
import org.specrunner.readers.IReader;
import org.specrunner.readers.ReaderException;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.result.status.Success;
import org.specrunner.sql.PluginFilter;
import org.specrunner.sql.database.CommandType;
import org.specrunner.sql.database.DatabaseException;
import org.specrunner.sql.database.DatabaseRegisterEvent;
import org.specrunner.sql.database.DatabaseTableEvent;
import org.specrunner.sql.database.IColumnReader;
import org.specrunner.sql.database.IDatabase;
import org.specrunner.sql.database.IDatabaseListener;
import org.specrunner.sql.database.IIdManager;
import org.specrunner.sql.database.ISequenceProvider;
import org.specrunner.sql.database.ISqlWrapperFactory;
import org.specrunner.sql.database.IStatementFactory;
import org.specrunner.sql.database.SqlWrapper;
import org.specrunner.sql.database.impl.ColumnReaderDefault;
import org.specrunner.sql.database.impl.DatabasePrintListener;
import org.specrunner.sql.database.impl.IdManagerDefault;
import org.specrunner.sql.database.impl.RegisterDefault;
import org.specrunner.sql.database.impl.SequenceProviderDefault;
import org.specrunner.sql.database.impl.SqlWrapperFactoryDefault;
import org.specrunner.sql.database.impl.StatementFactoryDefault;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.IDataFilter;
import org.specrunner.sql.meta.IRegister;
import org.specrunner.sql.meta.ReplicableException;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.UtilNames;
import org.specrunner.sql.meta.Value;
import org.specrunner.sql.meta.impl.DataFilterDefault;
import org.specrunner.sql.meta.impl.UtilSchema;
import org.specrunner.util.UtilLog;
import org.specrunner.util.UtilSql;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;
import org.specrunner.util.collections.ReverseIterable;
import org.specrunner.util.expression.UtilExpression;
import org.specrunner.util.xom.IPresentation;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.util.xom.core.PresentationCompare;
import org.specrunner.util.xom.core.PresentationException;
import org.specrunner.util.xom.node.CellAdapter;
import org.specrunner.util.xom.node.INodeHolder;
import org.specrunner.util.xom.node.RowAdapter;
import org.specrunner.util.xom.node.TableAdapter;

public class DatabaseDefault
implements IDatabase {
    public static final String FEATURE_FILTER = DatabaseDefault.class.getName() + ".filter";
    private String filter;
    protected INullEmptyHandler nullEmptyHandler = new NullEmptyHandlerDefault();
    protected ISequenceProvider sequenceProvider = new SequenceProviderDefault();
    protected IColumnReader columnReader = new ColumnReaderDefault();
    protected ISqlWrapperFactory sqlWrapperFactory = new SqlWrapperFactoryDefault();
    protected IStatementFactory statementFactory = new StatementFactoryDefault();
    protected IIdManager idManager = new IdManagerDefault();
    protected List<IDatabaseListener> listeners = new LinkedList<IDatabaseListener>();
    protected Boolean reuseScripts = Boolean.FALSE;
    protected String name;
    protected static ICache<String, String> xmlToSql = ((ICacheFactory)SRServices.get(ICacheFactory.class)).newCache(DatabaseDefault.class.getName());
    public static final String FEATURE_MD5_KEYS = DatabaseDefault.class.getName() + ".md5Keys";
    protected Boolean md5Keys = Boolean.FALSE;
    protected MessageDigest digester;
    public static final String FEATURE_LIMIT = DatabaseDefault.class.getName() + ".limit";
    private static final Integer DEFAULT_LIMIT = 100;
    private Integer limit = DEFAULT_LIMIT;

    public void initialize() {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_FILTER, (Object)this);
        fm.set(FEATURE_NULL_EMPTY_HANDLER, (Object)this);
        fm.set(FEATURE_SEQUENCE_PROVIDER, (Object)this);
        fm.set(FEATURE_COLUMN_READER, (Object)this);
        fm.set(FEATURE_SQL_WRAPPER_FACTORY, (Object)this);
        fm.set(FEATURE_STATEMENT_FACTORY, (Object)this);
        fm.set(FEATURE_ID_MANAGER, (Object)this);
        fm.set(FEATURE_LISTENERS, (Object)this);
        fm.set(FEATURE_REUSE_SCRIPTS, (Object)this);
        fm.set(FEATURE_MD5_KEYS, (Object)this);
        fm.set(FEATURE_LIMIT, (Object)this);
        this.idManager.reset();
    }

    public String getFilter() {
        return this.filter;
    }

    @DontEval
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public INullEmptyHandler getNullEmptyHandler() {
        return this.nullEmptyHandler;
    }

    public void setNullEmptyHandler(INullEmptyHandler nullEmptyHandler) {
        this.nullEmptyHandler = nullEmptyHandler;
    }

    public ISequenceProvider getSequenceProvider() {
        return this.sequenceProvider;
    }

    @Override
    public void setSequenceProvider(ISequenceProvider sequenceProvider) {
        this.sequenceProvider = sequenceProvider;
    }

    public IColumnReader getColumnReader() {
        return this.columnReader;
    }

    @Override
    public void setColumnReader(IColumnReader columnReader) {
        this.columnReader = columnReader;
    }

    public ISqlWrapperFactory getSqlWrapperFactory() {
        return this.sqlWrapperFactory;
    }

    @Override
    public void setSqlWrapperFactory(ISqlWrapperFactory sqlWrapperFactory) {
        this.sqlWrapperFactory = sqlWrapperFactory;
    }

    public IStatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    @Override
    public void setStatementFactory(IStatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    public IIdManager getIdManager() {
        return this.idManager;
    }

    @Override
    public void setIdManager(IIdManager idManager) {
        this.idManager = idManager;
    }

    public List<IDatabaseListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(List<IDatabaseListener> listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException("Listeners cannot be a null list.");
        }
        this.listeners = listeners;
    }

    public Boolean getReuseScripts() {
        return this.reuseScripts;
    }

    @Override
    public void setReuseScripts(Boolean reuseScripts) {
        this.reuseScripts = reuseScripts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Boolean getMd5Keys() {
        return this.md5Keys;
    }

    public void setMd5Keys(Boolean md5Keys) {
        this.md5Keys = md5Keys;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInitialize() {
        List<IDatabaseListener> list = this.listeners;
        synchronized (list) {
            for (IDatabaseListener listener : this.listeners) {
                listener.initialize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTableIn(DatabaseTableEvent event) throws DatabaseException {
        List<IDatabaseListener> list = this.listeners;
        synchronized (list) {
            for (IDatabaseListener listener : this.listeners) {
                listener.onTableIn(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegisterIn(DatabaseRegisterEvent event) throws DatabaseException {
        List<IDatabaseListener> list = this.listeners;
        synchronized (list) {
            for (IDatabaseListener listener : this.listeners) {
                listener.onRegisterIn(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegisterOut(DatabaseRegisterEvent event) throws DatabaseException {
        List<IDatabaseListener> list = this.listeners;
        synchronized (list) {
            for (IDatabaseListener listener : new ReverseIterable(this.listeners)) {
                listener.onRegisterOut(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTableOut(DatabaseTableEvent event) throws DatabaseException {
        List<IDatabaseListener> list = this.listeners;
        synchronized (list) {
            for (IDatabaseListener listener : new ReverseIterable(this.listeners)) {
                listener.onTableOut(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void perform(IContext context, IResultSet result, TableAdapter adapter, Connection connection, Schema schema, EMode mode) throws DatabaseException {
        Table table;
        IDataFilter afilter = this.getFilter(context, mode, schema);
        if (!afilter.accept(mode, schema)) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Schema ignored[" + mode + "]:" + schema.getAlias() + "(" + schema.getName() + ")");
            }
            UtilNode.appendCss((Node)adapter.getNode(), (String)"sqlschemaignore");
            return;
        }
        String tAlias = adapter.getAttribute("caption");
        if (tAlias == null) {
            List captions = adapter.getCaptions();
            if (captions.isEmpty()) {
                throw new DatabaseException("Tables must have a caption. The caption must be part of this set: " + schema.getAliasToTables().keySet());
            }
            tAlias = ((CellAdapter)captions.get(0)).getValue(context);
        }
        if ((table = schema.getAlias(tAlias)) == null) {
            throw new DatabaseException("Table '" + tAlias + "' [as '" + UtilNames.normalize(tAlias) + "'] not found in schema " + schema.getAlias() + "(" + schema.getName() + "), available alias: " + schema.getAliasToTables().keySet() + ", available tables: " + schema.getNamesToTables().keySet());
        }
        if (!afilter.accept(mode, table)) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Table ignored[" + mode + "]:" + table.getAlias() + "(" + table.getName() + ")");
            }
            UtilNode.appendCss((Node)adapter.getNode(), (String)"sqltableignore");
            return;
        }
        if (this.reuseScripts.booleanValue() && mode == EMode.INPUT) {
            ICache<String, String> iCache = xmlToSql;
            synchronized (iCache) {
                String sql;
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Reuse scripts activated for '" + table.getAlias() + "/" + table.getName() + "'.");
                }
                String xml = adapter.toXML();
                if (this.md5Keys.booleanValue()) {
                    if (this.digester == null) {
                        try {
                            this.digester = MessageDigest.getInstance("MD5");
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new DatabaseException("Could not generate MD5 keys for tables.", e);
                        }
                    }
                    this.digester.reset();
                    this.digester.update(xml.getBytes());
                    BigInteger number = new BigInteger(1, this.digester.digest());
                    xml = String.valueOf(number);
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("MD5 generated: " + xml);
                    }
                }
                if ((sql = (String)xmlToSql.get((Object)xml)) == null) {
                    List<IDatabaseListener> old = this.getListeners();
                    try {
                        final StringBuilder tmp = new StringBuilder();
                        LinkedList<IDatabaseListener> lista = new LinkedList<IDatabaseListener>(old);
                        lista.add(new DatabasePrintListener(){

                            @Override
                            protected void print(StringBuilder sb) {
                                tmp.append((CharSequence)sb);
                                tmp.append('\n');
                            }
                        });
                        this.setListeners(lista);
                        this.processTable(context, result, adapter, connection, mode, afilter, table);
                        xmlToSql.put((Object)xml, (Object)tmp.toString());
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Saved a script for table '" + table.getAlias() + "/" + table.getName() + "'.");
                        }
                        if (!UtilLog.LOG.isTraceEnabled()) return;
                        UtilLog.LOG.trace("CACHE FOR '" + table.getAlias() + "/" + table.getName() + "':\n" + xml + "\n IS \n" + tmp);
                    }
                    finally {
                        this.setListeners(old);
                    }
                }
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Reusing script " + (this.md5Keys != false ? "(MD5:" + xml + ")" : "") + " for table: '" + table.getAlias() + "/" + table.getName() + "'.");
                }
                if (sql.isEmpty()) return;
                Statement stmt = null;
                try {
                    stmt = connection.createStatement();
                    stmt.execute(sql);
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Reused '" + table.getAlias() + "/" + table.getName() + "'.");
                    }
                    if (!UtilLog.LOG.isTraceEnabled()) return;
                    UtilLog.LOG.trace("SCRIPT:\n" + sql + ".");
                }
                catch (SQLException e) {
                    throw new DatabaseException("Script errors: " + e.getMessage(), e);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            throw new DatabaseException("Could not close statement: " + e.getMessage(), e);
                        }
                    }
                }
                return;
            }
        }
        this.processTable(context, result, adapter, connection, mode, afilter, table);
    }

    protected void processTable(IContext context, IResultSet result, TableAdapter adapter, Connection connection, EMode mode, IDataFilter afilter, Table table) throws DatabaseException {
        try {
            table = table.copy();
        }
        catch (ReplicableException e) {
            throw new DatabaseException("Cannot create a copy of table " + table.getName() + " with alias " + table.getAlias() + ".", (Throwable)((Object)e));
        }
        List rows = adapter.getRows();
        if (rows.isEmpty()) {
            throw new DatabaseException("A valid table should have at least 1 row for headers (th's).");
        }
        RowAdapter header = null;
        int headerIndex = 0;
        for (int i = 0; i < adapter.getRowCount(); ++i) {
            headerIndex = i;
            RowAdapter tmp = adapter.getRow(i);
            if (UtilNode.isIgnore((Node)tmp.getNode())) continue;
            header = tmp;
            break;
        }
        if (header == null) {
            throw new DatabaseException(".");
        }
        List headers = header.getCells();
        Column[] columns = new Column[headers.size()];
        this.readHeadersColumns(context, mode, table, headers, columns, afilter);
        this.fireInitialize();
        if (!this.listeners.isEmpty()) {
            this.fireTableIn(new DatabaseTableEvent(context, result, adapter, this, connection, table, mode));
        }
        String defaultType = adapter.getAttribute("action");
        for (int i = headerIndex + 1; i < rows.size(); ++i) {
            int j;
            RowAdapter row = (RowAdapter)rows.get(i);
            if (UtilNode.isIgnore((Node)row.getNode())) continue;
            List tds = row.getCells();
            if (tds.isEmpty()) {
                throw new DatabaseException("Empty lines are useless. Invalid row[" + i + "]:" + row.getValue(context));
            }
            if (tds.size() != headers.size()) {
                throw new DatabaseException("Invalid number of cells at row: " + i + ". Expected " + headers.size() + " columns, received " + tds.size() + ".\n\t ROW:" + row);
            }
            int expectedCount = Integer.parseInt(row.getAttribute("count", "1"));
            String type = defaultType != null ? defaultType : ((CellAdapter)tds.get(0)).getValue(context);
            CommandType command = CommandType.get(type);
            if (command == null) {
                throw new DatabaseException("Invalid command type. '" + type + "' at (row: " + i + ", cell: 0). The first column is required for one of the following values: " + Arrays.toString((Object[])CommandType.values()));
            }
            HashMap<String, Value> filled = new HashMap<String, Value>();
            HashMap<String, CellAdapter> missing = new HashMap<String, CellAdapter>();
            RegisterDefault register = new RegisterDefault(table);
            int n = j = defaultType != null ? 0 : 1;
            while (j < tds.size()) {
                if (columns[j] != null) {
                    Column column = columns[j].copy();
                    CellAdapter td = (CellAdapter)tds.get(j);
                    try {
                        UtilSchema.setupColumn(context, table, column, (INodeHolder)td);
                    }
                    catch (ReaderException e) {
                        throw new DatabaseException(e);
                    }
                    catch (ConverterException e) {
                        throw new DatabaseException(e);
                    }
                    catch (FormatterException e) {
                        throw new DatabaseException(e);
                    }
                    catch (ComparatorException e) {
                        throw new DatabaseException(e);
                    }
                    String content = this.getAdjustContent(context, mode, command, column, afilter, (INodeHolder)td);
                    try {
                        Value v = this.getValue(context, mode, command, column, afilter, td, content);
                        if (v != null) {
                            register.add(v);
                            filled.put(column.getName(), v);
                        } else {
                            missing.put(column.getName(), td);
                        }
                    }
                    catch (ConverterException e) {
                        result.addResult((Status)Failure.INSTANCE, context.newBlock(td.getNode(), context.getPlugin()), (Throwable)new PluginException("Convertion error at row: " + i + ", cell: " + j + ".", (Throwable)e));
                    }
                    catch (FormatterException e) {
                        result.addResult((Status)Failure.INSTANCE, context.newBlock(td.getNode(), context.getPlugin()), (Throwable)new PluginException("Formatter error at row: " + i + ", cell: " + j + ".", (Throwable)e));
                    }
                }
                ++j;
            }
            if (!afilter.accept(mode, register)) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Register ignored[" + mode + "]:" + register + ".");
                }
                UtilNode.appendCss((Node)row.getNode(), (String)"sqlregisterignore");
                continue;
            }
            try {
                boolean error = false;
                switch (command) {
                    case INSERT: {
                        if (mode == EMode.INPUT) {
                            this.performInsert(context, result, connection, mode, table, afilter, register, filled, missing);
                            break;
                        }
                        this.performSelect(context, result, connection, table, command, register, expectedCount);
                        break;
                    }
                    case UPDATE: {
                        if (mode == EMode.INPUT) {
                            this.performUpdate(context, result, connection, table, register, expectedCount);
                            break;
                        }
                        this.performSelect(context, result, connection, table, command, register, expectedCount);
                        break;
                    }
                    case DELETE: {
                        if (mode == EMode.INPUT) {
                            this.performDelete(context, result, connection, table, register, expectedCount);
                            break;
                        }
                        this.performSelect(context, result, connection, table, command, register, 0);
                        break;
                    }
                    default: {
                        result.addResult((Status)Failure.INSTANCE, context.newBlock(row.getNode(), context.getPlugin()), (Throwable)new PluginException("Invalid command type. '" + type + "' at (row:" + i + ", cell:0)"));
                        error = true;
                    }
                }
                if (error) continue;
                result.addResult((Status)Success.INSTANCE, context.newBlock(row.getNode(), context.getPlugin()));
                continue;
            }
            catch (SQLException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                try {
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(row.getNode(), context.getPlugin()), (Throwable)new PluginException("Error in connection (" + connection.getMetaData().getURL() + "): " + e.getMessage(), (Throwable)e));
                    continue;
                }
                catch (SQLException e1) {
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    throw new DatabaseException("Could not log error:" + e1.getMessage(), e1);
                }
            }
            catch (DatabaseException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)((Object)e));
                }
                result.addResult((Status)Failure.INSTANCE, context.newBlock(row.getNode(), context.getPlugin()), (Throwable)((Object)e));
            }
        }
        if (!this.listeners.isEmpty()) {
            this.fireTableOut(new DatabaseTableEvent(context, result, adapter, this, connection, table, mode));
        }
    }

    protected IDataFilter getFilter(IContext context, EMode mode, Schema schema) throws DatabaseException {
        IDataFilter afilter = null;
        try {
            afilter = PluginFilter.getFilter(context, this.getFilter());
        }
        catch (PluginException e) {
            afilter = new DataFilterDefault();
        }
        try {
            afilter.setup(context, mode, schema);
        }
        catch (PluginException e) {
            throw new DatabaseException(e);
        }
        return afilter;
    }

    protected void readHeadersColumns(IContext context, EMode mode, Table table, List<CellAdapter> headers, Column[] columns, IDataFilter afilter) throws DatabaseException {
        HashMap<String, CellAdapter> found = new HashMap<String, CellAdapter>();
        for (int i = 0; i < headers.size(); ++i) {
            CellAdapter cell = headers.get(i);
            String cAlias = cell.getValue(context);
            columns[i] = table.getAlias(cAlias);
            Column column = columns[i];
            if (i > 0 && column == null && !UtilNode.isIgnore((Node)cell.getNode())) {
                throw new DatabaseException("Column '" + cAlias + "' [as '" + UtilNames.normalize(cAlias) + "'] not found in alias: " + table.getAliasToColumns().keySet() + " or in names: " + table.getNamesToColumns().keySet());
            }
            if (column == null) continue;
            CellAdapter old = (CellAdapter)found.get(column.getAlias());
            if (old != null) {
                throw new DatabaseException("Column with alias '" + column.getAlias() + "' repeated.");
            }
            found.put(column.getAlias(), cell);
            try {
                UtilSchema.setupColumn(context, table, column, (INodeHolder)cell);
            }
            catch (ReaderException e) {
                throw new DatabaseException(e);
            }
            catch (ConverterException e) {
                throw new DatabaseException(e);
            }
            catch (FormatterException e) {
                throw new DatabaseException(e);
            }
            catch (ComparatorException e) {
                throw new DatabaseException(e);
            }
            if (afilter.accept(mode, column)) continue;
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info("Adding 'true' comparator to ignore a column.");
            }
            column.setComparator((IComparator)SRServices.getComparatorManager().get((Object)"true"));
            UtilNode.appendCss((Node)cell.getNode(), (String)"sqlcolumnignore");
        }
    }

    protected String getAdjustContent(IContext context, EMode mode, CommandType command, Column column, IDataFilter afilter, INodeHolder nh) throws DatabaseException {
        try {
            IReader reader = column.getReader();
            String previous = reader.read(context, (Object)nh, null);
            if (reader.isReplacer()) {
                String value = UtilExpression.replace((String)nh.getAttribute("value", previous), (IContext)context, (boolean)true);
                if (previous != null && !previous.equals(value)) {
                    nh.setValue(value);
                }
                return value;
            }
            return previous;
        }
        catch (ReaderException e) {
            throw new DatabaseException(e);
        }
        catch (PluginException e) {
            throw new DatabaseException(e);
        }
    }

    protected Value getValue(IContext context, EMode mode, CommandType command, Column column, IDataFilter afilter, CellAdapter td, String content) throws ConverterException, DatabaseException, FormatterException {
        boolean isNull = this.nullEmptyHandler.isNull(mode, content);
        boolean isEmpty = this.nullEmptyHandler.isEmpty(mode, content);
        boolean isVirtual = column.isVirtual();
        IConverter converter = td.getConverter(column.getConverter());
        if (isNull || isEmpty || isVirtual || converter.accept((Object)content)) {
            List args;
            Object obj = null;
            obj = isNull ? null : (isEmpty ? "" : (isVirtual ? content : converter.convert((Object)content, (args = td.getArguments(column.getArguments())).isEmpty() ? null : args.toArray())));
            IFormatter formatter = td.getFormatter(column.getFormatter());
            if (formatter != null) {
                List args2 = td.getFormatterArguments(column.getFormatterArguments());
                obj = formatter.format(obj, args2.isEmpty() ? null : args2.toArray());
            }
            if (!afilter.accept(mode, column, obj)) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Ignore value '" + obj + "' in column '" + column.getAlias() + "'.");
                }
                UtilNode.appendCss((Node)td.getNode(), (String)"sqlvalueignore");
                return null;
            }
            if (!isNull && obj == null && command == CommandType.INSERT && mode == EMode.INPUT) {
                obj = column.getDefaultValue();
            }
            return new Value(column, td, obj, column.getComparator());
        }
        return null;
    }

    protected void performInsert(IContext context, IResultSet result, Connection connection, EMode mode, Table table, IDataFilter afilter, IRegister register, Map<String, Value> filled, Map<String, CellAdapter> missing) throws DatabaseException, SQLException {
        this.addMissingValues(mode, table, afilter, register, filled, missing);
        this.performIn(context, result, connection, this.sqlWrapperFactory.createInputWrapper(table, CommandType.INSERT, register, 1), table, register);
    }

    protected void addMissingValues(EMode mode, Table table, IDataFilter afilter, IRegister register, Map<String, Value> filled, Map<String, CellAdapter> missing) throws DatabaseException {
        for (Column column : table.getColumns()) {
            if (filled.get(column.getName()) != null) continue;
            Value v = null;
            Object defaultValue = column.getDefaultValue();
            if (defaultValue != null) {
                v = new Value(column, missing.get(column.getName()), defaultValue, column.getComparator());
            } else if (column.isSequence()) {
                v = new Value(column, missing.get(column.getName()), this.sequenceProvider.nextValue(column.getSequence()), column.getComparator());
            }
            if (v == null) continue;
            if (!(afilter.accept(mode, column) && afilter.accept(mode, column, null) && afilter.accept(mode, column, v.getValue()))) {
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Ignore default of ignored column '" + column.getAlias() + "(" + column.getName() + ")'.");
                }
                if (v.getCell() == null) continue;
                UtilNode.appendCss((Node)v.getCell().getNode(), (String)"sqlvalueignore");
                continue;
            }
            register.add(v);
        }
    }

    protected void performUpdate(IContext context, IResultSet result, Connection connection, Table table, IRegister register, int expectedCount) throws DatabaseException, SQLException {
        this.performIn(context, result, connection, this.sqlWrapperFactory.createInputWrapper(table, CommandType.UPDATE, register, expectedCount), table, register);
    }

    protected void performDelete(IContext context, IResultSet result, Connection connection, Table table, IRegister register, int expectedCount) throws DatabaseException, SQLException {
        this.performIn(context, result, connection, this.sqlWrapperFactory.createInputWrapper(table, CommandType.DELETE, register, expectedCount), table, register);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performIn(IContext context, IResultSet result, Connection connection, SqlWrapper wrapper, Table table, IRegister register) throws DatabaseException, SQLException {
        Map<String, Integer> namesToIndexes = wrapper.getNamesToIndexes();
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug(wrapper.getSql() + ". MAP: " + namesToIndexes + ". VALUES: " + register);
        }
        this.idManager.clear();
        PreparedStatement pstmt = null;
        try {
            pstmt = this.statementFactory.getInput(connection, wrapper.getSql(), table);
            Map<Integer, Object> indexesToValues = this.prepareInputValues(context, table, register, namesToIndexes);
            for (Map.Entry<Integer, Object> e : indexesToValues.entrySet()) {
                pstmt.setObject(e.getKey(), e.getValue());
            }
            int count = pstmt.executeUpdate();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("[" + count + "]=" + wrapper.getSql());
            }
            if (wrapper.getExpectedCount() != Integer.MAX_VALUE && wrapper.getExpectedCount() != count) {
                throw new DatabaseException("The expected count (" + wrapper.getExpectedCount() + ") does not match, received = " + count + ".\n\tSQL: " + wrapper.getSql() + "\n\tARGS: " + register);
            }
            DatabaseMetaData meta = connection.getMetaData();
            if (this.idManager.hasKeys() && meta.supportsGetGeneratedKeys()) {
                this.idManager.readKeys(wrapper, table, register, pstmt);
            }
            if (!this.listeners.isEmpty()) {
                this.fireRegisterIn(new DatabaseRegisterEvent(context, result, this, connection, table, register, wrapper, indexesToValues));
            }
        }
        finally {
            if (pstmt != null) {
                this.statementFactory.release(pstmt);
            }
        }
    }

    protected Map<Integer, Object> prepareInputValues(IContext context, Table table, IRegister register, Map<String, Integer> namesToIndexes) throws DatabaseException {
        HashMap<Integer, Object> indexesToValues = new HashMap<Integer, Object>();
        for (Value v : register) {
            Column column = v.getColumn();
            Integer index = namesToIndexes.get(column.getName());
            if (index == null) continue;
            String tableOrAlias = register.getTableOrAlias(context, column);
            Object obj = v.getValue();
            if (column.isVirtual()) {
                obj = this.idManager.lookup(tableOrAlias, String.valueOf(obj));
            }
            if (column.isReference()) {
                this.idManager.append(table.getAlias(), v.getCell().getValue(context));
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("performIn.SET(" + index + "," + column.getName() + ") = " + obj);
            }
            indexesToValues.put(index, obj);
        }
        return indexesToValues;
    }

    protected void performSelect(IContext context, IResultSet result, Connection connection, Table table, CommandType command, IRegister register, int expectedCount) throws DatabaseException, SQLException {
        this.performOut(context, result, connection, this.sqlWrapperFactory.createOutputWrapper(table, command, register, expectedCount), table, register);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performOut(IContext context, IResultSet result, Connection connection, SqlWrapper wrapper, Table table, IRegister register) throws DatabaseException, SQLException {
        Map<String, Integer> namesToIndexes = wrapper.getNamesToIndexes();
        String sql = wrapper.getSql();
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug(sql + ". MAP:" + namesToIndexes + ". values = " + register + ". indexes = " + namesToIndexes);
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = this.statementFactory.getOutput(connection, wrapper.getSql(), table);
            Map<Integer, Object> indexesToValues = this.prepareSelectValues(context, connection, register, namesToIndexes);
            for (Map.Entry<Integer, Object> e : indexesToValues.entrySet()) {
                pstmt.setObject(e.getKey(), e.getValue());
            }
            try (ResultSet rs = null;){
                rs = pstmt.executeQuery();
                if (wrapper.getExpectedCount() == 1) {
                    if (!rs.next()) {
                        throw new DatabaseException("None register found with the given conditions: " + sql + " and values: [" + register + "]");
                    }
                    this.compareRegister(context, result, connection, register, namesToIndexes, rs);
                    if (rs.next()) {
                        throw new DatabaseException("More than one register satisfy the condition: " + sql + "[" + register + "]\n" + this.dumpRs("Extra itens:", rs));
                    }
                } else if (rs.next()) {
                    throw new DatabaseException("A result for " + sql + "[" + register + "] was not expected.\n" + this.dumpRs("Unexpected items:", rs));
                }
            }
            if (!this.listeners.isEmpty()) {
                this.fireRegisterOut(new DatabaseRegisterEvent(context, result, this, connection, table, register, wrapper, indexesToValues));
            }
        }
        finally {
            if (pstmt != null) {
                this.statementFactory.release(pstmt);
            }
        }
    }

    protected Map<Integer, Object> prepareSelectValues(IContext context, Connection connection, IRegister register, Map<String, Integer> namesToIndexes) throws DatabaseException, SQLException {
        HashMap<Integer, Object> indexesToValues = new HashMap<Integer, Object>();
        for (Value v : register) {
            Column column = v.getColumn();
            Integer index = namesToIndexes.get(column.getName());
            if (index == null) continue;
            Object value = v.getValue();
            if (column.isVirtual()) {
                value = this.idManager.find(register.getTableOrAlias(context, column), String.valueOf(value), column, connection, this.statementFactory);
            }
            if (column.isDate()) {
                IComparator comp = column.getComparator();
                if (!(comp instanceof ComparatorDate)) {
                    throw new DatabaseException("Date columns must have comparators of type 'date'. Current type:" + comp.getClass());
                }
                ComparatorDate comparator = (ComparatorDate)comp;
                comparator.initialize();
                Date dateBefore = new Date(((Date)value).getTime() - comparator.getTolerance());
                Date dateAfter = new Date(((Date)value).getTime() + comparator.getTolerance());
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("performOut.SET(" + index + "," + column.getAlias() + "," + column.getName() + ") = " + dateBefore);
                    UtilLog.LOG.debug("performOut.SET(" + (index + 1) + "," + column.getAlias() + "," + column.getName() + ") = " + dateAfter);
                }
                indexesToValues.put(index, dateBefore);
                indexesToValues.put(index + 1, dateAfter);
            } else {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("performOut.SET(" + index + "," + column.getAlias() + "," + column.getName() + ") = " + value);
                }
                indexesToValues.put(index, value);
            }
            v.setValue(value);
        }
        return indexesToValues;
    }

    protected void compareRegister(IContext context, IResultSet result, Connection connection, IRegister register, Map<String, Integer> namesToIndexes, ResultSet rs) throws DatabaseException, SQLException {
        for (Value v : register) {
            Column column = v.getColumn();
            Integer index = namesToIndexes.get(column.getName());
            if (index != null) continue;
            IComparator comparator = v.getComparator();
            Object received = this.columnReader.read(rs, column);
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("CHECK(" + v.getValue() + ") = " + received);
            }
            Object value = v.getValue();
            String tableOrAlias = register.getTableOrAlias(context, column);
            if (column.isVirtual()) {
                value = this.idManager.find(register.getTableOrAlias(context, column), String.valueOf(value), column, connection, this.statementFactory);
            }
            CellAdapter cell = v.getCell();
            comparator.initialize();
            try {
                boolean notMatch;
                boolean bl = notMatch = !comparator.match(value, received);
                if (notMatch) {
                    Object expected = v.getValue();
                    if (column.isVirtual()) {
                        received = this.idManager.lookup(tableOrAlias, String.valueOf(received));
                    }
                    String expStr = UtilSql.toString((Object)this.value(v.getColumn(), expected));
                    String recStr = UtilSql.toString((Object)this.value(v.getColumn(), received));
                    this.shortView(cell, expected, expStr, recStr);
                    Object error = null;
                    error = expStr.equals(recStr) ? new PresentationCompare(expected, received) : new DefaultAlignmentException("Values are different.", expStr, recStr);
                    result.addResult((Status)Failure.INSTANCE, context.newBlock(cell.getNode(), context.getPlugin()), (Throwable)new PresentationException((IPresentation)error));
                    continue;
                }
                String str = String.valueOf(value);
                if (str.equals(cell.getValue(context))) continue;
                cell.append(" {" + str + "}");
            }
            catch (ComparatorException e) {
                result.addResult((Status)Failure.INSTANCE, context.newBlock(cell.getNode(), context.getPlugin()), (Throwable)e);
            }
        }
    }

    protected Object value(Column c, Object exp) {
        Object out;
        block3: {
            out = exp;
            if (c.getConverter() instanceof IConverterReverse) {
                IConverterReverse converter = (IConverterReverse)c.getConverter();
                List<String> arguments = c.getArguments();
                try {
                    out = converter.revert(exp, arguments.toArray(new Object[arguments.size()]));
                }
                catch (ConverterException e) {
                    if (!UtilLog.LOG.isTraceEnabled()) break block3;
                    UtilLog.LOG.trace("Unable to revert '" + exp + "' with: " + converter + "" + arguments);
                }
            }
        }
        return out;
    }

    protected void shortView(CellAdapter cell, Object expected, String expStr, String recStr) {
        if (!expStr.equals(expected)) {
            Element spanExp = new Element("span");
            spanExp.addAttribute(new Attribute("class", "compare"));
            spanExp.appendChild((Node)new Element("br"));
            Element spanLabelExp = new Element("span");
            spanLabelExp.addAttribute(new Attribute("class", "expected"));
            spanExp.appendChild((Node)spanLabelExp);
            spanLabelExp.appendChild(" (expected):");
            spanExp.appendChild(expStr);
            cell.append((Node)spanExp);
        }
        Element spanRec = new Element("span");
        spanRec.addAttribute(new Attribute("class", "compare"));
        spanRec.appendChild((Node)new Element("br"));
        Element spanLabelRec = new Element("span");
        spanLabelRec.addAttribute(new Attribute("class", "received"));
        spanRec.appendChild((Node)spanLabelRec);
        spanLabelRec.appendChild(" (received):");
        spanRec.appendChild(recStr);
        cell.append((Node)spanRec);
    }

    protected String dumpRs(String prefix, ResultSet rs) throws SQLException {
        StringBuilder sb = new StringBuilder(prefix);
        ResultSetMetaData meta = rs.getMetaData();
        int count = meta.getColumnCount();
        int index = 0;
        do {
            sb.append("\n");
            for (int i = 1; i <= count; ++i) {
                sb.append((i == 1 ? "\t" : ", ") + meta.getColumnName(i) + ":" + rs.getObject(i));
            }
        } while (++index < this.limit && rs.next());
        return sb.toString();
    }

    @Override
    public void release() throws PluginException {
        this.statementFactory.release();
    }

    public Object getObject() {
        return this;
    }

    public void destroy() {
        xmlToSql.release();
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Cache of scripts released: " + xmlToSql);
        }
    }
}

