/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.converters.core.AbstractConverterTimezone;
import org.specrunner.features.IFeatureManager;
import org.specrunner.result.IResultSet;
import org.specrunner.sql.database.DatabaseException;
import org.specrunner.sql.database.DatabaseRegisterEvent;
import org.specrunner.sql.database.DatabaseTableEvent;
import org.specrunner.sql.database.IDatabaseListener;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheFactory;
import org.specrunner.util.output.IOutputFactory;

public class DatabasePrintListener
implements IDatabaseListener {
    protected static ICache<String, TimeZone> cacheTimezone = ((ICacheFactory)SRServices.get(ICacheFactory.class)).newCache(AbstractConverterTimezone.class.getName());
    private String timezone;
    protected SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSS");
    protected SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd 00:00:00.00000");

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimeZone getZone() {
        String name = this.getTimezone();
        if (name != null) {
            ICache<String, TimeZone> iCache = cacheTimezone;
            synchronized (iCache) {
                TimeZone tz = (TimeZone)cacheTimezone.get((Object)name);
                if (tz == null) {
                    tz = TimeZone.getTimeZone(name);
                    if (tz == null) {
                        throw new RuntimeException("Invalid timezone:" + name);
                    }
                    cacheTimezone.put((Object)name, (Object)tz);
                }
                return tz;
            }
        }
        return TimeZone.getDefault();
    }

    public void initialize() {
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(AbstractConverterTimezone.FEATURE_TIMEZONE, (Object)this);
        TimeZone zone = this.getZone();
        this.formatTime.setTimeZone(zone);
        this.formatDate.setTimeZone(zone);
    }

    @Override
    public void onTableIn(DatabaseTableEvent event) throws DatabaseException {
    }

    @Override
    public void onRegisterIn(DatabaseRegisterEvent event) throws DatabaseException {
        this.dump(event.getContext(), event.getResult(), event.getWrapper().getSql(), event.getIndexesToValues());
    }

    @Override
    public void onRegisterOut(DatabaseRegisterEvent event) throws DatabaseException {
        this.dump(event.getContext(), event.getResult(), event.getWrapper().getSql(), event.getIndexesToValues());
    }

    @Override
    public void onTableOut(DatabaseTableEvent event) throws DatabaseException {
    }

    public void dump(IContext context, IResultSet result, String sql, Map<Integer, Object> arguments) {
        StringBuilder sb = new StringBuilder();
        int counter = 1;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '?') {
                Object obj = arguments.get(counter++);
                this.textByType(sb, obj);
                continue;
            }
            sb.append(c);
        }
        sb.append(';');
        this.print(sb);
    }

    protected void textByType(StringBuilder sb, Object obj) {
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof Date) {
            this.printDate(sb, (Date)obj);
        } else if (obj instanceof Number) {
            sb.append(obj);
        } else {
            sb.append("'" + obj + "'");
        }
    }

    protected void printDate(StringBuilder sb, Date obj) {
        if (obj instanceof Timestamp) {
            sb.append("{ts '" + this.formatTime.format(obj) + "'}");
        } else {
            sb.append("{ts '" + this.formatDate.format(obj) + "'}");
        }
    }

    protected void print(StringBuilder sb) {
        ((IOutputFactory)SRServices.get(IOutputFactory.class)).currentOutput().println((Object)sb.toString());
    }
}

