/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.specrunner.comparators.IComparator;
import org.specrunner.comparators.core.ComparatorDate;
import org.specrunner.converters.ConverterException;
import org.specrunner.sql.database.DatabaseException;
import org.specrunner.sql.database.IIdManager;
import org.specrunner.sql.database.IStatementFactory;
import org.specrunner.sql.database.SqlWrapper;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.IRegister;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.Value;
import org.specrunner.util.UtilLog;

public class IdManagerDefault
implements IIdManager {
    protected Map<String, Object> valuesToIds = new HashMap<String, Object>();
    protected String table;
    protected String value;

    @Override
    public void reset() {
        this.valuesToIds.clear();
    }

    @Override
    public void clear() {
        this.table = null;
        this.value = null;
    }

    @Override
    public void append(String table, String value) {
        if (this.table == null) {
            this.table = table;
            this.value = value;
        } else {
            this.value = this.value + ";" + value;
        }
    }

    @Override
    public boolean hasKeys() {
        return this.table != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readKeys(SqlWrapper wrapper, Table table, IRegister register, PreparedStatement pstmt) throws SQLException {
        switch (wrapper.getType()) {
            case INSERT: {
                try (ResultSet rs = null;){
                    rs = pstmt.getGeneratedKeys();
                    ResultSetMetaData metaData = rs.getMetaData();
                    while (rs.next()) {
                        for (int j = 1; j < metaData.getColumnCount() + 1; ++j) {
                            this.bind(rs.getObject(j));
                        }
                    }
                    break;
                }
            }
            case UPDATE: {
                for (Value value : register) {
                    if (!value.getColumn().isKey()) continue;
                    this.bind(value.getValue());
                }
                break;
            }
        }
    }

    protected void bind(Object obj) {
        this.bind(this.makeKey(this.table, this.value), obj);
    }

    protected void bind(String value, Object id) {
        this.valuesToIds.put(value, id);
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("Added value -> id: " + value + " -> " + id);
        }
    }

    @Override
    public Object lookup(String table, String value) {
        String key = this.makeKey(table, value);
        Object obj = this.valuesToIds.get(key);
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("'" + key + "' recovered as " + obj);
        }
        return obj;
    }

    protected String makeKey(String table, Object value) {
        return table + "." + value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object find(String tableOrAlias, String value, Column column, Connection connection, IStatementFactory statementFactory) throws DatabaseException, SQLException {
        String key = this.makeKey(tableOrAlias, value);
        Object result = this.lookup(tableOrAlias, value);
        if (result == null) {
            Schema schema = column.getParent().getParent();
            Table table = schema.getAlias(tableOrAlias);
            if (table == null) {
                throw new DatabaseException("Virtual column '" + tableOrAlias + "' not found in schema " + schema.getName() + ". It must be a name in domain set of: " + schema.getAliasToTables());
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("Recover virtual key for (" + key + ") at " + schema.getName() + "." + table.getName());
            }
            StringTokenizer st = new StringTokenizer(String.valueOf(value), ";");
            List<Column> references = table.getReferences();
            if (st.countTokens() != references.size()) {
                throw new DatabaseException("Number of reference columns (" + references.size() + ") is different from value tokens (" + st.countTokens() + ").");
            }
            PreparedStatement pstmt = statementFactory.getOutput(connection, this.createSelect(table), table);
            int i = 1;
            while (st.hasMoreTokens()) {
                Column reference = references.get(i - 1);
                String token = st.nextToken();
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Convert(" + reference.getTableOrAlias() + "." + token + ")");
                }
                Object tmp = null;
                if (reference.isVirtual()) {
                    tmp = this.find(reference.getTableOrAlias(), token, reference, connection, statementFactory);
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("Virtual part(" + token + ") found:" + tmp + " ." + (tmp != null ? tmp.getClass() : "null"));
                    }
                } else {
                    try {
                        tmp = reference.getConverter().convert((Object)token, reference.getArguments().toArray());
                        if (UtilLog.LOG.isDebugEnabled()) {
                            UtilLog.LOG.debug("Converted to:" + tmp + " ." + (tmp != null ? tmp.getClass() : "null"));
                        }
                    }
                    catch (ConverterException e) {
                        throw new DatabaseException(e);
                    }
                }
                if (reference.isDate()) {
                    IComparator comp = reference.getComparator();
                    if (!(comp instanceof ComparatorDate)) {
                        throw new DatabaseException("Date columns must have comparators of type 'date'. Current type:" + comp.getClass());
                    }
                    ComparatorDate comparator = (ComparatorDate)comp;
                    comparator.initialize();
                    Date dateBefore = new Date(((Date)tmp).getTime() - comparator.getTolerance());
                    Date dateAfter = new Date(((Date)tmp).getTime() + comparator.getTolerance());
                    if (UtilLog.LOG.isDebugEnabled()) {
                        UtilLog.LOG.debug("Date range in virtual lookup [" + dateBefore + " to " + dateAfter + "]");
                    }
                    pstmt.setObject(i++, dateBefore);
                    pstmt.setObject(i++, dateAfter);
                    continue;
                }
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("findValue.SET(" + i + "," + reference.getTableOrAlias() + "," + reference.getName() + ") = " + tmp);
                }
                pstmt.setObject(i++, tmp);
            }
            try (ResultSet rs = null;){
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug("Query(" + key + "): " + pstmt);
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    for (Column c : table.getKeys()) {
                        result = rs.getObject(c.getName());
                        this.bind(key, result);
                    }
                    if (!UtilLog.LOG.isDebugEnabled()) continue;
                    for (Column c : references) {
                        UtilLog.LOG.debug("Value for " + c.getName() + ": " + rs.getObject(c.getName()));
                    }
                }
            }
        }
        if (UtilLog.LOG.isDebugEnabled()) {
            UtilLog.LOG.debug("Virtual key (" + key + ") replaced by '" + result + "'");
        }
        return result;
    }

    protected String createSelect(Table table) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        List<Column> keys = table.getKeys();
        int i = 0;
        for (Column c : keys) {
            sb.append((i++ == 0 ? "" : ",") + c.getName());
        }
        List<Column> references = table.getReferences();
        if (UtilLog.LOG.isDebugEnabled()) {
            for (Column c : references) {
                sb.append((i++ == 0 ? "" : ",") + c.getName());
            }
        }
        sb.append(" from ");
        sb.append(table.getParent().getName() + "." + table.getName());
        sb.append(" where ");
        i = 0;
        for (Column c : references) {
            sb.append((i++ == 0 ? "" : " AND ") + c.getName() + (c.isDate() ? " between ? and ?" : " = ?"));
        }
        return sb.toString();
    }
}

