/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.util.LinkedList;
import org.specrunner.context.IContext;
import org.specrunner.sql.database.DatabaseException;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.IRegister;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.UtilNames;
import org.specrunner.sql.meta.Value;
import org.specrunner.util.UtilLog;

public class RegisterDefault
extends LinkedList<Value>
implements IRegister {
    private Table parent;

    public RegisterDefault(Table parent) {
        this.parent = parent;
    }

    @Override
    public Table getParent() {
        return this.parent;
    }

    @Override
    public String getTableOrAlias(IContext context, Column column) throws DatabaseException {
        String alias = column.getTableOrAlias();
        String pointer = column.getPointer();
        if (pointer != null) {
            alias = null;
            for (Value vp : this) {
                if (!pointer.equals(vp.getColumn().getAlias())) continue;
                alias = UtilNames.normalize(vp.getCell().getValue(context));
                break;
            }
            if (alias == null) {
                throw new DatabaseException("The column '" + column.getTableOrAlias() + "' point to a non-existing column '" + pointer + "' of this table. Adjust attribute 'pointer' into database mapping file.");
            }
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("pointer(" + pointer + ") -> " + alias);
            }
        }
        return alias;
    }

    @Override
    public Value getByName(String name) {
        for (Value v : this) {
            if (!v.getColumn().getName().equalsIgnoreCase(name)) continue;
            return v;
        }
        return null;
    }

    @Override
    public Value getByAlias(String alias) {
        for (Value v : this) {
            if (!v.getColumn().getAlias().equalsIgnoreCase(alias)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean hasKeys() {
        for (Value v : this) {
            if (!v.getColumn().isKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReferences() {
        for (Value v : this) {
            if (!v.getColumn().isReference()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasKeysOrReferences() {
        for (Value v : this) {
            if (!v.getColumn().isKey() && !v.getColumn().isReference()) continue;
            return true;
        }
        return false;
    }
}

