/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.util.HashMap;
import java.util.Map;
import org.specrunner.sql.database.CommandType;
import org.specrunner.sql.database.ISqlWrapperFactory;
import org.specrunner.sql.database.SqlWrapper;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.IRegister;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.Value;

public class SqlWrapperFactoryDefault
implements ISqlWrapperFactory {
    @Override
    public SqlWrapper createInputWrapper(Table table, CommandType command, IRegister register, int expectedCount) {
        switch (command) {
            case INSERT: {
                return this.createInsertWrapper(table, register, expectedCount);
            }
            case UPDATE: {
                return this.createUpdateWrapper(table, register, expectedCount);
            }
            case DELETE: {
                return this.createDeleteWrapper(table, register, expectedCount);
            }
        }
        return null;
    }

    protected SqlWrapper createInsertWrapper(Table table, IRegister register, int expectedCount) {
        HashMap<String, Integer> namesToIndexes = new HashMap<String, Integer>();
        StringBuilder sb = this.sqlInsert(table, register, namesToIndexes);
        return this.insertWrapper(sb, namesToIndexes, expectedCount);
    }

    protected StringBuilder sqlInsert(Table table, IRegister register, Map<String, Integer> namesToIndexes) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into " + table.getParent().getName() + "." + table.getName());
        StringBuilder sbColumns = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        int i = 1;
        for (Value e : register) {
            Column column = e.getColumn();
            sbColumns.append(column.getName() + ",");
            if (column.isSequence()) {
                sbValues.append(e.getValue() + ",");
                continue;
            }
            sbValues.append("?,");
            namesToIndexes.put(column.getName(), i++);
        }
        if (sbColumns.length() > 1) {
            sbColumns.setLength(sbColumns.length() - 1);
        }
        if (sbValues.length() > 1) {
            sbValues.setLength(sbValues.length() - 1);
        }
        sb.append(" (");
        sb.append((CharSequence)sbColumns);
        sb.append(") values (");
        sb.append((CharSequence)sbValues);
        sb.append(")");
        return sb;
    }

    protected SqlWrapper insertWrapper(StringBuilder sb, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.insert(sb.toString(), namesToIndexes, expectedCount);
    }

    protected SqlWrapper createUpdateWrapper(Table table, IRegister register, int expectedCount) {
        HashMap<String, Integer> namesToIndexes = new HashMap<String, Integer>();
        StringBuilder sb = this.sqlUpdate(table, register, namesToIndexes);
        return this.updateWrapper(sb, namesToIndexes, !register.hasKeysOrReferences() ? Integer.MAX_VALUE : expectedCount);
    }

    protected StringBuilder sqlUpdate(Table table, IRegister register, Map<String, Integer> namesToIndexes) {
        Column column;
        StringBuilder sb = new StringBuilder();
        sb.append("update " + table.getParent().getName() + "." + table.getName() + " set ");
        boolean hasKeys = false;
        boolean hasReferences = false;
        for (Value v : register) {
            hasKeys = hasKeys || v.getColumn().isKey();
            hasReferences = hasReferences || v.getColumn().isReference();
        }
        StringBuilder sbColumns = new StringBuilder();
        int i = 1;
        if (hasKeys) {
            for (Value v : register) {
                column = v.getColumn();
                if (column.isKey()) continue;
                namesToIndexes.put(column.getName(), i++);
                sbColumns.append(column.getName() + " = ?,");
            }
        } else if (hasReferences) {
            for (Value v : register) {
                column = v.getColumn();
                if (column.isReference()) continue;
                namesToIndexes.put(column.getName(), i++);
                sbColumns.append(column.getName() + " = ?,");
            }
        } else {
            for (Value v : register) {
                column = v.getColumn();
                namesToIndexes.put(column.getName(), i++);
                sbColumns.append(column.getName() + " = ?,");
            }
        }
        if (sbColumns.length() > 1) {
            sbColumns.setLength(sbColumns.length() - 1);
        }
        sb.append((CharSequence)sbColumns);
        StringBuilder sbConditions = new StringBuilder();
        String and = " AND ";
        if (hasKeys) {
            for (Value v : register) {
                Column column2 = v.getColumn();
                if (!column2.isKey()) continue;
                namesToIndexes.put(column2.getName(), i++);
                sbConditions.append(column2.getName() + " = ? " + and);
            }
        } else if (hasReferences) {
            for (Value v : register) {
                Column column3 = v.getColumn();
                if (!column3.isReference()) continue;
                namesToIndexes.put(column3.getName(), i++);
                sbConditions.append(column3.getName() + " = ? " + and);
            }
        } else {
            for (Value v : register) {
                Column column4 = v.getColumn();
                namesToIndexes.put(column4.getName(), i++);
                sbConditions.append(column4.getName() + " = ? " + and);
            }
        }
        if (sbConditions.length() > 1 + and.length()) {
            sbConditions.setLength(sbConditions.length() - (1 + and.length()));
        }
        if (sbConditions.length() > 0) {
            sb.append(" where ");
            sb.append((CharSequence)sbConditions);
        }
        return sb;
    }

    protected SqlWrapper updateWrapper(StringBuilder sb, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.update(sb.toString(), namesToIndexes, expectedCount);
    }

    protected SqlWrapper createDeleteWrapper(Table table, IRegister register, int expectedCount) {
        HashMap<String, Integer> namesToIndexes = new HashMap<String, Integer>();
        StringBuilder sb = this.sqlDelete(table, register, namesToIndexes);
        return this.deleteWrapper(sb, namesToIndexes, register.isEmpty() ? Integer.MAX_VALUE : expectedCount);
    }

    protected StringBuilder sqlDelete(Table table, IRegister register, Map<String, Integer> namesToIndexes) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from " + table.getParent().getName() + "." + table.getName());
        boolean hasKeys = false;
        boolean hasReferences = false;
        for (Value v : register) {
            hasKeys = hasKeys || v.getColumn().isKey();
            hasReferences = hasReferences || v.getColumn().isReference();
        }
        StringBuilder sbConditions = new StringBuilder();
        int i = 1;
        String and = " AND ";
        if (hasKeys) {
            for (Value v : register) {
                Column column = v.getColumn();
                if (!column.isKey()) continue;
                namesToIndexes.put(column.getName(), i++);
                sbConditions.append(column.getName() + " = ?" + and);
            }
        } else if (hasReferences) {
            for (Value v : register) {
                Column column = v.getColumn();
                if (!column.isReference()) continue;
                namesToIndexes.put(column.getName(), i++);
                sbConditions.append(column.getName() + " = ?" + and);
            }
        } else {
            for (Value v : register) {
                Column column = v.getColumn();
                namesToIndexes.put(column.getName(), i++);
                sbConditions.append(column.getName() + " = ?" + and);
            }
        }
        if (sbConditions.length() > and.length()) {
            sbConditions.setLength(sbConditions.length() - and.length());
        }
        if (sbConditions.length() > 0) {
            sb.append(" where ");
            sb.append((CharSequence)sbConditions);
        }
        return sb;
    }

    protected SqlWrapper deleteWrapper(StringBuilder sb, Map<String, Integer> namesToIndexes, int expectedCount) {
        return SqlWrapper.delete(sb.toString(), namesToIndexes, expectedCount);
    }

    @Override
    public SqlWrapper createOutputWrapper(Table table, CommandType command, IRegister register, int expectedCount) {
        return this.createSelectWrapper(table, command, register, expectedCount);
    }

    protected SqlWrapper createSelectWrapper(Table table, CommandType command, IRegister register, int expectedCount) {
        HashMap<String, Integer> namesToIndexes = new HashMap<String, Integer>();
        StringBuilder sb = this.sqlSelect(table, register, namesToIndexes);
        return this.selectWrapper(command, sb, namesToIndexes, expectedCount);
    }

    protected StringBuilder sqlSelect(Table table, IRegister register, Map<String, Integer> namesToIndexes) {
        String name;
        StringBuilder sbVal = new StringBuilder();
        StringBuilder sbPla = new StringBuilder();
        boolean hasKeys = false;
        boolean hasReferences = false;
        for (Value v : register) {
            hasKeys = hasKeys || v.getColumn().isKey();
            hasReferences = hasReferences || v.getColumn().isReference();
        }
        String and = " AND ";
        int i = 1;
        if (hasKeys) {
            for (Value v : register) {
                name = v.getColumn().getName();
                if (!v.getColumn().isKey()) {
                    sbVal.append(name + ",");
                    continue;
                }
                sbPla.append(name + (v.getColumn().isDate() ? " between ? and ?" : " = ?") + (i > 0 ? and : ""));
                namesToIndexes.put(name, i++);
                if (!v.getColumn().isDate()) continue;
                ++i;
            }
        } else if (hasReferences) {
            for (Value v : register) {
                name = v.getColumn().getName();
                if (!v.getColumn().isReference()) {
                    sbVal.append(name + ",");
                    continue;
                }
                sbPla.append(name + (v.getColumn().isDate() ? " between ? and ?" : " = ?") + (i > 0 ? and : ""));
                namesToIndexes.put(name, i++);
                if (!v.getColumn().isDate()) continue;
                ++i;
            }
        } else {
            for (Value v : register) {
                name = v.getColumn().getName();
                sbVal.append(name + ",");
                sbPla.append(name + (v.getColumn().isDate() ? " between ? and ?" : " = ?") + (i > 0 ? and : ""));
                namesToIndexes.put(name, i++);
                if (!v.getColumn().isDate()) continue;
                ++i;
            }
        }
        if (sbVal.length() == 0) {
            for (Value v : register) {
                sbVal.append(v.getColumn().getName() + ",");
            }
        }
        if (sbVal.length() > 1) {
            sbVal.setLength(sbVal.length() - 1);
        }
        if (sbPla.length() > and.length()) {
            sbPla.setLength(sbPla.length() - and.length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append((CharSequence)sbVal);
        sb.append(" from " + table.getParent().getName() + "." + table.getName());
        sb.append(" where ");
        sb.append((CharSequence)sbPla);
        return sb;
    }

    protected SqlWrapper selectWrapper(CommandType command, StringBuilder sb, Map<String, Integer> namesToIndexes, int expectedCount) {
        switch (command) {
            case INSERT: {
                return this.insertWrapper(sb, namesToIndexes, expectedCount);
            }
            case UPDATE: {
                return this.updateWrapper(sb, namesToIndexes, expectedCount);
            }
            case DELETE: {
                return this.deleteWrapper(sb, namesToIndexes, expectedCount);
            }
        }
        return null;
    }
}

