/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.database.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.specrunner.SRServices;
import org.specrunner.plugins.PluginException;
import org.specrunner.sql.database.impl.AbstractStatementFactory;
import org.specrunner.sql.database.impl.PreparedStatementCleaner;
import org.specrunner.sql.meta.Table;
import org.specrunner.util.UtilLog;
import org.specrunner.util.cache.ICache;
import org.specrunner.util.cache.ICacheCleaner;
import org.specrunner.util.cache.ICacheFactory;

public class StatementFactoryDefault
extends AbstractStatementFactory {
    protected ICache<String, PreparedStatement> inputs = ((ICacheFactory)SRServices.get(ICacheFactory.class)).newCache(StatementFactoryDefault.class.getName() + ".inputs", (ICacheCleaner)PreparedStatementCleaner.INSTANCE.get());
    protected ICache<String, PreparedStatement> outputs = ((ICacheFactory)SRServices.get(ICacheFactory.class)).newCache(StatementFactoryDefault.class.getName() + ".outputs", (ICacheCleaner)PreparedStatementCleaner.INSTANCE.get());

    @Override
    public PreparedStatement getInput(Connection connection, String sql, Table table) throws SQLException {
        PreparedStatement pstmt = (PreparedStatement)this.inputs.get((Object)sql);
        if (pstmt == null) {
            pstmt = this.createInStatement(connection, sql, table);
            this.putInput(sql, pstmt);
        } else {
            pstmt.clearParameters();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("REUSE: " + pstmt);
            }
        }
        return pstmt;
    }

    @Override
    public void putInput(String sql, PreparedStatement pstmt) {
        this.inputs.put((Object)sql, (Object)pstmt);
    }

    @Override
    public PreparedStatement getOutput(Connection connection, String sql, Table table) throws SQLException {
        PreparedStatement pstmt = (PreparedStatement)this.outputs.get((Object)sql);
        if (pstmt == null) {
            pstmt = connection.prepareStatement(sql);
            this.putOutput(sql, pstmt);
        } else {
            pstmt.clearParameters();
            if (UtilLog.LOG.isDebugEnabled()) {
                UtilLog.LOG.debug("REUSE:" + pstmt);
            }
        }
        return pstmt;
    }

    @Override
    public void putOutput(String sql, PreparedStatement pstmt) {
        this.outputs.put((Object)sql, (Object)pstmt);
    }

    @Override
    public void release(PreparedStatement pstmt) throws SQLException {
    }

    @Override
    public void release() throws PluginException {
        this.inputs.release();
        this.outputs.release();
    }
}

