/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.specrunner.sql.IDataSourceProvider;
import org.specrunner.util.UtilLog;

public class SimpleDataSource
implements IDataSourceProvider,
DataSource {
    private Connection connection;
    private final String driver;
    private final String url;
    private final String user;
    private final String password;
    private int timeout;

    public SimpleDataSource(String driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public DataSource getDataSource() {
        return this;
    }

    @Override
    public void release() {
        block4: {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Connection " + this.connection + " closed.");
                }
            }
            catch (SQLException e) {
                if (!UtilLog.LOG.isDebugEnabled()) break block4;
                UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Method unsupported.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.get(this.driver, this.url, this.user, this.password);
    }

    protected Connection get(String driver, String url, String user, String pwd) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e);
            }
            this.connection = DriverManager.getConnection(url, user, pwd);
        }
        return this.connection;
    }

    public String toString() {
        return SimpleDataSource.class.getSimpleName() + "(" + this.driver + "|" + this.url + "|" + this.user + "|" + this.password + ")";
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

