/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.meta;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.specrunner.context.IContext;
import org.specrunner.sql.meta.IMergeable;
import org.specrunner.sql.meta.IReplicable;
import org.specrunner.sql.meta.MergeableException;
import org.specrunner.sql.meta.ReplicableException;
import org.specrunner.sql.meta.SchemaException;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.UtilNames;
import org.specrunner.util.reset.IResetableExtended;

public class Schema
implements IReplicable<Schema>,
IMergeable<Schema>,
IResetableExtended {
    private String alias;
    private String name;
    private List<Table> tables = new LinkedList<Table>();
    private Map<String, Table> aliasToTables = new HashMap<String, Table>();
    private Map<String, Table> namesToTables = new HashMap<String, Table>();

    public String getAlias() {
        return this.alias;
    }

    public Schema setAlias(String alias) {
        this.alias = alias == null ? null : UtilNames.normalize(alias);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Schema setName(String name) {
        this.name = name == null ? null : name.toUpperCase();
        return this;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public Schema setTables(List<Table> tables) {
        this.tables = tables;
        return this;
    }

    public Schema add(Table table) throws SchemaException {
        if (this.namesToTables.containsKey(table.getName())) {
            throw new SchemaException("Table with name '" + table.getName() + "' already exist in schema (" + this.name + "," + this.alias + "), read before error: " + this.namesToTables.keySet());
        }
        if (this.aliasToTables.containsKey(table.getAlias())) {
            throw new SchemaException("Table with alias '" + table.getAlias() + "' already exist in schema (" + this.name + "," + this.alias + "), read before error: " + this.aliasToTables.keySet());
        }
        this.tables.add(table);
        this.aliasToTables.put(table.getAlias(), table);
        this.namesToTables.put(table.getName(), table);
        table.setParent(this);
        return this;
    }

    public Table getAlias(String alias) {
        String key = alias == null ? null : UtilNames.normalize(alias);
        Table table = this.aliasToTables.get(key);
        if (table == null) {
            table = this.getName(key);
        }
        return table;
    }

    public Table getName(String name) {
        return this.namesToTables.get(name == null ? null : name.toUpperCase());
    }

    public Map<String, Table> getAliasToTables() {
        return this.aliasToTables;
    }

    public void setAliasToTables(Map<String, Table> aliasToTables) {
        this.aliasToTables = aliasToTables;
    }

    public Map<String, Table> getNamesToTables() {
        return this.namesToTables;
    }

    public void setNamesToTables(Map<String, Table> namesToTables) {
        this.namesToTables = namesToTables;
    }

    @Override
    public Schema copy() throws ReplicableException {
        Schema copy = new Schema().setName(this.name).setAlias(this.alias);
        for (Table t : this.tables) {
            try {
                copy.add(t.copy());
            }
            catch (SchemaException e) {
                throw new ReplicableException((Throwable)((Object)e));
            }
        }
        return copy;
    }

    @Override
    public void merge(Schema other) throws MergeableException {
        if (other == null) {
            return;
        }
        this.setName(other.name);
        this.setAlias(other.alias);
        for (Table t : other.getTables()) {
            Table old = this.getName(t.getName());
            if (old == null) {
                try {
                    this.add(t.copy());
                    continue;
                }
                catch (SchemaException e) {
                    throw new MergeableException((Throwable)((Object)e));
                }
                catch (ReplicableException e) {
                    throw new MergeableException((Throwable)((Object)e));
                }
            }
            old.merge(t);
        }
    }

    public void initialize(IContext context) {
        for (Table t : this.tables) {
            t.initialize(context);
        }
    }
}

