/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.meta;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.specrunner.context.IContext;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.IMergeable;
import org.specrunner.sql.meta.IReplicable;
import org.specrunner.sql.meta.MergeableException;
import org.specrunner.sql.meta.ReplicableException;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.SchemaException;
import org.specrunner.sql.meta.UtilNames;
import org.specrunner.util.reset.IResetableExtended;

public class Table
implements IReplicable<Table>,
IMergeable<Table>,
IResetableExtended {
    private Schema parent;
    private String alias;
    private String name;
    private List<Column> columns = new LinkedList<Column>();
    private Map<String, Column> aliasToColumns = new HashMap<String, Column>();
    private Map<String, Column> namesToColumns = new HashMap<String, Column>();
    private Map<String, String> aliasToTables = new HashMap<String, String>();

    public Schema getParent() {
        return this.parent;
    }

    public Table setParent(Schema parent) {
        this.parent = parent;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public Table setAlias(String alias) {
        this.alias = alias == null ? null : UtilNames.normalize(alias.toLowerCase());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Table setName(String name) {
        this.name = name == null ? null : name.toUpperCase();
        return this;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Table setColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public Table add(Column column) throws SchemaException {
        if (this.namesToColumns.containsKey(column.getName())) {
            throw new SchemaException("Column with name '" + column.getName() + "' already exist in table (" + this.name + "," + this.alias + "), read before error: " + this.namesToColumns.keySet());
        }
        if (this.aliasToColumns.containsKey(column.getAlias())) {
            throw new SchemaException("Column with alias '" + column.getAlias() + "' already exist in table (" + this.name + "," + this.alias + "), read before error: " + this.aliasToColumns.keySet());
        }
        this.columns.add(column);
        if (column.getTable() != null) {
            this.aliasToTables.put(column.getAlias(), column.getTable());
            this.aliasToColumns.put(this.createAlias(column.getAlias(), column.getTable()), column);
        } else {
            this.aliasToColumns.put(column.getAlias(), column);
        }
        this.namesToColumns.put(column.getName(), column);
        column.setParent(this);
        return this;
    }

    protected String createAlias(String prefix, String suffix) {
        return prefix + "(table:" + suffix + ")";
    }

    public Column getAlias(String alias) {
        Column column;
        String key = alias == null ? null : UtilNames.normalize(alias);
        String table = this.aliasToTables.get(key);
        if (table != null) {
            key = this.createAlias(key, table);
        }
        if ((column = this.aliasToColumns.get(key)) == null) {
            column = this.getName(key);
        }
        return column;
    }

    public Column getName(String name) {
        return this.namesToColumns.get(name == null ? null : name.toUpperCase());
    }

    public Map<String, Column> getAliasToColumns() {
        return this.aliasToColumns;
    }

    public void setAliasToColumns(Map<String, Column> aliasToColumns) {
        this.aliasToColumns = aliasToColumns;
    }

    public Map<String, Column> getNamesToColumns() {
        return this.namesToColumns;
    }

    public void setNamesToColumns(Map<String, Column> namesToColumns) {
        this.namesToColumns = namesToColumns;
    }

    public List<Column> getKeys() {
        LinkedList<Column> result = new LinkedList<Column>();
        for (Column c : this.columns) {
            if (!c.isKey()) continue;
            result.add(c);
        }
        return result;
    }

    public List<Column> getReferences() {
        LinkedList<Column> result = new LinkedList<Column>();
        for (Column c : this.columns) {
            if (!c.isReference()) continue;
            result.add(c);
        }
        return result;
    }

    public List<Column> getVirtual() {
        LinkedList<Column> result = new LinkedList<Column>();
        for (Column c : this.columns) {
            if (!c.isVirtual()) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public Table copy() throws ReplicableException {
        Table copy = new Table().setParent(this.parent).setName(this.name).setAlias(this.alias);
        for (Column c : this.columns) {
            try {
                copy.add(c.copy());
            }
            catch (SchemaException e) {
                throw new ReplicableException((Throwable)((Object)e));
            }
        }
        return copy;
    }

    @Override
    public void merge(Table other) throws MergeableException {
        if (other == null) {
            return;
        }
        this.setName(other.name);
        this.setAlias(other.alias);
        for (Column c : other.getColumns()) {
            Column old = this.getName(c.getName());
            if (old == null) {
                try {
                    this.add(c.copy());
                    continue;
                }
                catch (SchemaException e) {
                    throw new MergeableException((Throwable)((Object)e));
                }
            }
            old.merge(c);
        }
    }

    public void initialize(IContext context) {
        for (Column c : this.columns) {
            c.initialize(context);
        }
    }
}

