/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.meta.impl;

import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import org.specrunner.SRServices;
import org.specrunner.context.IContext;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.ISchemaLoaderXML;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.meta.impl.UtilSchema;
import org.specrunner.util.xom.node.INodeHolder;
import org.specrunner.util.xom.node.INodeHolderFactory;

public abstract class AbstractSchemaLoaderXOM
implements ISchemaLoaderXML {
    protected Schema loadDocument(IContext context, Document document) throws Exception {
        Schema schema = new Schema();
        INodeHolderFactory holderFactory = (INodeHolderFactory)SRServices.get(INodeHolderFactory.class);
        INodeHolder nSchema = holderFactory.newHolder((Node)document.getRootElement());
        schema.setName(nSchema.getAttribute("name")).setAlias(nSchema.getAttribute("alias", schema.getName()));
        Nodes nTables = nSchema.getNode().query("child::table");
        for (int i = 0; i < nTables.size(); ++i) {
            INodeHolder nTable = holderFactory.newHolder(nTables.get(i));
            Table table = new Table();
            table.setName(nTable.getAttribute("name")).setAlias(nTable.getAttribute("alias", table.getName()));
            schema.add(table);
            Nodes nColumns = nTable.getNode().query("child::column");
            for (int j = 0; j < nColumns.size(); ++j) {
                INodeHolder nColumn = holderFactory.newHolder(nColumns.get(j));
                Column column = new Column();
                UtilSchema.setupColumn(context, table, column, nColumn);
                table.add(column);
            }
        }
        return schema;
    }
}

