/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.meta.impl;

import java.io.IOException;
import java.io.InputStream;
import nu.xom.Builder;
import org.specrunner.context.IContext;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.meta.impl.AbstractSchemaLoaderXOM;
import org.specrunner.util.UtilLog;

public class SchemaLoaderXOM
extends AbstractSchemaLoaderXOM {
    protected Builder builder;

    @Override
    public Schema load(IContext context, Object source) {
        Schema schema = null;
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(String.valueOf(source));
            if (in == null) {
                throw new RuntimeException("Resource '" + source + "' not found.");
            }
            schema = this.loadDocument(context, this.getBuilder().build(in));
        }
        catch (Exception e) {
            if (UtilLog.LOG.isInfoEnabled()) {
                UtilLog.LOG.info(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                if (UtilLog.LOG.isDebugEnabled()) {
                    UtilLog.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        return schema;
    }

    protected Builder getBuilder() {
        if (this.builder == null) {
            this.builder = new Builder();
        }
        return this.builder;
    }
}

