/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.report;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.converters.ConverterException;
import org.specrunner.converters.IConverterReverse;
import org.specrunner.expressions.EMode;
import org.specrunner.expressions.INullEmptyHandler;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.report.RegisterType;
import org.specrunner.sql.report.TableReport;
import org.specrunner.util.UtilLog;
import org.specrunner.util.UtilSql;
import org.specrunner.util.aligner.core.DefaultAlignmentException;
import org.specrunner.util.xom.IPresentation;
import org.specrunner.util.xom.UtilNode;

public class LineReport
implements IPresentation {
    private RegisterType type;
    private TableReport tableReport;
    private INullEmptyHandler nullEmptyHandler;
    private Map<String, Integer> columnsToIndexes = new HashMap<String, Integer>();
    private List<String> expectedObjects = new LinkedList<String>();
    private List<String> receivedObjects = new LinkedList<String>();

    public RegisterType getType() {
        return this.type;
    }

    public void setType(RegisterType type) {
        this.type = type;
    }

    public TableReport getTable() {
        return this.tableReport;
    }

    public void setTable(TableReport table) {
        this.tableReport = table;
    }

    public Map<String, Integer> getColumnsToIndexes() {
        return this.columnsToIndexes;
    }

    public void setColumnsToIndexes(Map<String, Integer> columnsToIndexes) {
        this.columnsToIndexes = columnsToIndexes;
    }

    public List<String> getExpectedObjects() {
        return this.expectedObjects;
    }

    public void setExpectedObjects(List<String> expectedObjects) {
        this.expectedObjects = expectedObjects;
    }

    public List<String> getReceivedObjects() {
        return this.receivedObjects;
    }

    public void setReceivedObjects(List<String> receivedObjects) {
        this.receivedObjects = receivedObjects;
    }

    public LineReport(RegisterType type, TableReport table, INullEmptyHandler nullEmptyHandler) {
        this.type = type;
        this.tableReport = table;
        this.nullEmptyHandler = nullEmptyHandler;
    }

    public String asString() {
        String rec;
        Integer index;
        Integer colsize;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%10s|", this.type.asString()));
        switch (this.type) {
            case EXTRA: {
                this.line(sb, this.receivedObjects);
                break;
            }
            case MISSING: {
                this.line(sb, this.expectedObjects);
                break;
            }
            case DIFFERENT: {
                for (Column c : this.tableReport.getColumns()) {
                    colsize = this.tableReport.getSize(c);
                    index = this.columnsToIndexes.get(c.getName());
                    if (index != null) {
                        if (c.isKey()) {
                            rec = this.receivedObjects.get(index);
                            sb.append(String.format(" %-" + colsize + "s", this.nullOrEmpty(c, rec)));
                        } else {
                            String exp = this.expectedObjects.get(index);
                            sb.append(String.format(" EXP:%-" + (colsize - "EXP:".length()) + "s", this.nullOrEmptyWrapp(c, exp)));
                        }
                    } else {
                        sb.append(String.format(" %-" + colsize + "s", ""));
                    }
                    sb.append('|');
                }
                break;
            }
        }
        if (this.type == RegisterType.DIFFERENT) {
            sb.append("\n\t");
            sb.append(String.format("%10s|", ""));
            for (Column c : this.tableReport.getColumns()) {
                colsize = this.tableReport.getSize(c);
                index = this.columnsToIndexes.get(c.getName());
                if (index != null) {
                    if (!c.isKey()) {
                        rec = this.receivedObjects.get(index);
                        sb.append(String.format(" REC:%-" + (colsize - "REC:".length()) + "s", this.nullOrEmptyWrapp(c, rec)));
                    } else {
                        sb.append(String.format(" %-" + colsize + "s", ""));
                    }
                } else {
                    sb.append(String.format(" %-" + colsize + "s", ""));
                }
                sb.append('|');
            }
        }
        return sb.toString();
    }

    protected void line(StringBuilder sb, List<String> list) {
        for (Column c : this.tableReport.getColumns()) {
            Integer index = this.columnsToIndexes.get(c.getName());
            if (index != null) {
                sb.append(String.format(" %-" + this.tableReport.getSize(c) + "s", c.isKey() ? this.nullOrEmpty(c, list.get(index)) : this.nullOrEmptyWrapp(c, list.get(index))));
            } else {
                sb.append(String.format(" %-" + this.tableReport.getSize(c) + "s", this.nullOrEmpty(c, null)));
            }
            sb.append('|');
        }
    }

    public String nullOrEmpty(Column c, String exp) {
        String out = this.value(c, exp);
        return out == null ? this.nullEmptyHandler.nullValue(EMode.COMPARE) : (out.isEmpty() ? this.nullEmptyHandler.emptyValue(EMode.COMPARE) : out);
    }

    protected String value(Column c, String exp) {
        String out;
        block3: {
            out = exp;
            if (c.getConverter() instanceof IConverterReverse) {
                IConverterReverse converter = (IConverterReverse)c.getConverter();
                List<String> arguments = c.getArguments();
                try {
                    Object tmp = converter.revert((Object)exp, arguments.toArray(new Object[arguments.size()]));
                    out = tmp == null ? null : String.valueOf(tmp);
                }
                catch (ConverterException e) {
                    if (!UtilLog.LOG.isTraceEnabled()) break block3;
                    UtilLog.LOG.trace("Unable to revert '" + exp + "' with: " + converter + "" + arguments);
                }
            }
        }
        return out;
    }

    public String nullOrEmptyWrapp(Column c, String exp) {
        String out = this.value(c, exp);
        return out == null ? this.nullEmptyHandler.nullValue(EMode.COMPARE) : (out.isEmpty() ? this.nullEmptyHandler.emptyValue(EMode.COMPARE) : (out.equals(exp) ? "'" + out + "'" : out));
    }

    public Node asNode() {
        Element tr = new Element("tr");
        tr.addAttribute(new Attribute("class", this.type.getStyle() + " sr_lreport"));
        Element td = new Element("td");
        tr.appendChild((Node)td);
        UtilNode.appendCss((Node)td, (String)(this.type.getStyle() + " sr_lreport"));
        td.appendChild(this.type.asNode());
        switch (this.type) {
            case EXTRA: {
                this.line(tr, this.receivedObjects);
                break;
            }
            case MISSING: {
                this.line(tr, this.expectedObjects);
                break;
            }
            case DIFFERENT: {
                for (Column c : this.tableReport.getColumns()) {
                    Integer index = this.columnsToIndexes.get(c.getName());
                    td = new Element("td");
                    if (index != null) {
                        UtilNode.appendCss((Node)td, (String)(this.type.getStyle() + " sr_lreport"));
                        String rec = this.receivedObjects.get(index);
                        if (c.isKey()) {
                            td.appendChild(this.nullOrEmpty(c, rec));
                        } else {
                            UtilNode.appendCss((Node)td, (String)(td.getAttributeValue("class") + " " + this.type.getStyle() + "_cell"));
                            String exp = this.expectedObjects.get(index);
                            td.appendChild(new DefaultAlignmentException("", this.nullOrEmpty(c, exp), this.nullOrEmpty(c, rec)).asNode());
                        }
                    }
                    tr.appendChild((Node)td);
                }
                break;
            }
        }
        return tr;
    }

    protected void line(Element tr, List<String> vals) {
        for (Column c : this.tableReport.getColumns()) {
            Integer index = this.columnsToIndexes.get(c.getName());
            Element td = new Element("td");
            if (index != null) {
                UtilNode.appendCss((Node)td, (String)this.type.getStyle());
                td.appendChild(c.isKey() ? this.nullOrEmpty(c, vals.get(index)) : this.nullOrEmptyWrapp(c, vals.get(index)));
            } else {
                td.appendChild(this.nullOrEmpty(c, null));
            }
            tr.appendChild((Node)td);
        }
    }

    public void add(Column c, int index, Object expected, Object received) {
        this.columnsToIndexes.put(c.getName(), index);
        String strExp = UtilSql.toStringNullable((Object)expected);
        String strRec = UtilSql.toStringNullable((Object)received);
        int sizeMax = 0;
        if (strExp == null || strRec == null) {
            String nullValue = this.nullEmptyHandler.nullValue(EMode.COMPARE);
            String emptyValue = this.nullEmptyHandler.emptyValue(EMode.COMPARE);
            sizeMax = Math.max(String.valueOf(nullValue).length(), String.valueOf(emptyValue).length());
        }
        String strExpInv = this.nullOrEmptyWrapp(c, strExp);
        String strRecInv = this.nullOrEmptyWrapp(c, strRec);
        sizeMax = Math.max(strExp != null ? strExp.length() : sizeMax, strRec != null ? strRec.length() : sizeMax);
        sizeMax = Math.max(strExpInv != null ? strExpInv.length() : sizeMax, strRecInv != null ? strRecInv.length() : sizeMax);
        this.tableReport.add(c, this.type == RegisterType.DIFFERENT ? sizeMax + "EXP:".length() : sizeMax);
        this.expectedObjects.add(strExp);
        this.receivedObjects.add(strRec);
    }

    public boolean isEmpty() {
        return this.columnsToIndexes.isEmpty();
    }
}

