/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.report;

import java.util.LinkedList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.sql.meta.Schema;
import org.specrunner.sql.report.TableReport;
import org.specrunner.util.xom.IPresentation;

public class SchemaReport
implements IPresentation {
    private Schema schema;
    private List<TableReport> tables = new LinkedList<TableReport>();

    public SchemaReport(Schema schema) {
        this.schema = schema;
    }

    public void add(TableReport tr) {
        this.tables.add(tr);
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append(this.schema.getAlias() + "(" + this.schema.getName() + ")\n");
        for (TableReport r : this.tables) {
            result.append("\t" + r.asString() + "\n");
        }
        return result.toString();
    }

    public Node asNode() {
        Element table = new Element("table");
        table.addAttribute(new Attribute("class", "sr_sreport"));
        Element caption = new Element("caption");
        table.appendChild((Node)caption);
        caption.addAttribute(new Attribute("class", "sr_sreport"));
        caption.appendChild(this.schema.getAlias());
        Element sup = new Element("sup");
        sup.addAttribute(new Attribute("class", "sr_treport"));
        sup.appendChild(this.schema.getName());
        caption.appendChild((Node)sup);
        for (TableReport r : this.tables) {
            Element tr = new Element("tr");
            table.appendChild((Node)tr);
            tr.addAttribute(new Attribute("class", "sr_sreport"));
            Element td = new Element("td");
            tr.appendChild((Node)td);
            td.addAttribute(new Attribute("class", "sr_sreport"));
            td.appendChild(r.asNode());
            td.appendChild((Node)new Element("p"));
        }
        return table;
    }
}

