/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.sql.report;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.specrunner.sql.meta.Column;
import org.specrunner.sql.meta.Table;
import org.specrunner.sql.report.LineReport;
import org.specrunner.util.xom.IPresentation;

public class TableReport
implements IPresentation {
    public static final String KEY = "*";
    public static final String REF = "R";
    public static final String VIR = "V";
    public static final String SEQ = "S";
    public static final String ENUM = "E";
    public static final String DATE = "D";
    private Table table;
    private List<Column> columns = new LinkedList<Column>();
    private Map<Column, Integer> sizes = new HashMap<Column, Integer>();
    private List<LineReport> lines = new LinkedList<LineReport>();

    public TableReport(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<LineReport> getLines() {
        return this.lines;
    }

    public void setLines(List<LineReport> lines) {
        this.lines = lines;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void add(Column column, Integer size) {
        if (!this.columns.contains(column)) {
            int i;
            for (i = 0; i < this.columns.size() && this.columns.get(i).isKey(); ++i) {
            }
            if (!column.isKey()) {
                while (i < this.columns.size() && this.columns.get(i).isReference()) {
                    ++i;
                }
            }
            this.columns.add(i, column);
            String strKey = column.isKey() ? KEY : "";
            String strRef = column.isReference() ? REF : "";
            String strVir = column.isVirtual() ? VIR : "";
            String strSeq = column.isSequence() ? SEQ : "";
            String strEnum = column.isEnum() ? ENUM : "";
            String strDate = column.isDate() ? DATE : "";
            int comp = strKey.length() + strRef.length() + strVir.length() + strSeq.length() + strEnum.length() + strDate.length();
            if (comp > 0) {
                comp += " []".length();
            }
            this.sizes.put(column, Math.max(column.getAlias().length(), column.getName().length()) + comp + 1);
        }
        this.sizes.put(column, Math.max(size, this.sizes.get(column)));
    }

    public Integer getSize(Column column) {
        return this.sizes.get(column);
    }

    public void setSize(Column column, Integer size) {
        this.sizes.put(column, size);
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public void add(LineReport lr) {
        this.lines.add(lr);
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.table.getAlias() + " (" + this.table.getName() + ")\n");
        StringBuilder tmpFill = new StringBuilder();
        for (Column c : this.columns) {
            int i = this.sizes.get(c);
            for (int j = 0; j < i; ++j) {
                tmpFill.append(j == 0 ? (char)'+' : '-');
            }
            tmpFill.append("--");
        }
        tmpFill.append('+');
        String fill = tmpFill.toString();
        int index = 0;
        for (LineReport lr : this.lines) {
            if (index++ == 0) {
                sb.append("\t" + String.format("%10s%s", "+---------", fill) + "\n");
                sb.append(String.format("\t%10s|", ""));
                for (Column c : this.columns) {
                    sb.append(String.format(" %-" + this.sizes.get(c) + "s", c.getAlias()));
                    sb.append('|');
                }
                sb.append("\n");
                sb.append(String.format("\t%10s|", "ERROR(S)"));
                for (Column c : this.columns) {
                    StringBuilder suffix = new StringBuilder();
                    if (c.isKey() || c.isReference() || c.isVirtual() || c.isSequence() || c.isEnum() || c.isDate()) {
                        suffix.append(" [");
                        if (c.isKey()) {
                            suffix.append(KEY);
                        }
                        if (c.isReference()) {
                            suffix.append(REF);
                        }
                        if (c.isVirtual()) {
                            suffix.append(VIR);
                        }
                        if (c.isSequence()) {
                            suffix.append(SEQ);
                        }
                        if (c.isEnum()) {
                            suffix.append(ENUM);
                        }
                        if (c.isDate()) {
                            suffix.append(DATE);
                        }
                        suffix.append("]");
                    }
                    sb.append(String.format(" %-" + this.sizes.get(c) + "s", c.getName() + suffix));
                    sb.append('|');
                }
                sb.append("\n");
                sb.append("\t" + String.format("%10s%s", "", fill) + "\n");
            }
            sb.append("\t" + lr.asString() + "\n");
            sb.append("\t" + String.format("%10s%s", "", fill) + "\n");
        }
        return sb.toString();
    }

    public Node asNode() {
        Element result = new Element("table");
        result.addAttribute(new Attribute("class", "sr_treport"));
        Element cap = new Element("caption");
        cap.addAttribute(new Attribute("class", "sr_treport"));
        cap.appendChild(this.table.getAlias());
        Element sup = new Element("sup");
        sup.addAttribute(new Attribute("class", "sr_treport"));
        sup.appendChild(this.table.getName());
        cap.appendChild((Node)sup);
        result.appendChild((Node)cap);
        int index = 0;
        for (LineReport lr : this.lines) {
            if (index++ == 0) {
                Element tr = new Element("tr");
                result.appendChild((Node)tr);
                tr.addAttribute(new Attribute("class", "sr_lreport"));
                Element th = new Element("th");
                tr.appendChild((Node)th);
                th.addAttribute(new Attribute("class", "sr_lreport"));
                th.appendChild("ERROR(S)");
                for (Column c : this.columns) {
                    th = new Element("th");
                    tr.appendChild((Node)th);
                    th.addAttribute(new Attribute("class", "sr_lreport"));
                    th.appendChild(c.getAlias());
                    th.appendChild((Node)new Element("br"));
                    Element span = new Element("span");
                    span.addAttribute(new Attribute("class", "sr_treport"));
                    span.appendChild(c.getName());
                    if (c.isKey() || c.isReference() || c.isVirtual() || c.isSequence() || c.isEnum() || c.isDate()) {
                        span.appendChild(" [");
                        if (c.isKey()) {
                            span.appendChild(KEY);
                        }
                        if (c.isReference()) {
                            span.appendChild(REF);
                        }
                        if (c.isVirtual()) {
                            span.appendChild(VIR);
                        }
                        if (c.isSequence()) {
                            span.appendChild(SEQ);
                        }
                        if (c.isEnum()) {
                            span.appendChild(ENUM);
                        }
                        if (c.isDate()) {
                            span.appendChild(DATE);
                        }
                        span.appendChild("]");
                    }
                    th.appendChild((Node)span);
                }
            }
            result.appendChild(lr.asNode());
        }
        return result;
    }
}

