/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.tomcat;

import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.features.IFeatureManager;
import org.specrunner.plugins.ActionType;
import org.specrunner.plugins.ENext;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginScoped;
import org.specrunner.plugins.type.Assertion;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Success;
import org.specrunner.reuse.IReusable;
import org.specrunner.reuse.IReuseManager;
import org.specrunner.reuse.core.AbstractReusable;
import org.specrunner.util.UtilLog;

public class PluginStartTomcat
extends AbstractPluginScoped {
    public static final String SERVER_NAME = "tomcatName";
    private static Object lock = new Object();
    public static final String FEATURE_PORT = PluginStartTomcat.class.getName() + ".port";
    private Integer port;
    public static final String FEATURE_BASEDIR = PluginStartTomcat.class.getName() + ".basedir";
    private String basedir;
    public static final String FEATURE_CONTEXT = PluginStartTomcat.class.getName() + ".context";
    private String context;
    public static final String FEATURE_WAR = PluginStartTomcat.class.getName() + ".war";
    private String war;
    public static final String FEATURE_DYNAMIC = PluginStartTomcat.class.getName() + ".dynamic";
    private Boolean dynamic = true;
    public static final String FEATURE_REUSE = PluginStartTomcat.class.getName() + ".reuse";
    private Boolean reuse = false;

    public PluginStartTomcat() {
        this.setName(SERVER_NAME);
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getWar() {
        return this.war;
    }

    public void setWar(String war) {
        this.war = war;
    }

    public Boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public ActionType getActionType() {
        return Assertion.INSTANCE;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        if (this.basedir == null) {
            fm.set(FEATURE_BASEDIR, (Object)this);
        }
        if (this.port == null) {
            fm.set(FEATURE_PORT, (Object)this);
        }
        if (context == null) {
            fm.set(FEATURE_CONTEXT, (Object)this);
        }
        if (this.war == null) {
            fm.set(FEATURE_WAR, (Object)this);
        }
        fm.set(FEATURE_DYNAMIC, (Object)this);
        fm.set(FEATURE_REUSE, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ENext doStart(IContext context, IResultSet result) throws PluginException {
        Object object = lock;
        synchronized (object) {
            try {
                IReuseManager reusables = (IReuseManager)SRServices.get(IReuseManager.class);
                if (this.reuse.booleanValue()) {
                    HashMap<String, Object> cfg = new HashMap<String, Object>();
                    cfg.put("name", this.getName());
                    cfg.put("basedir", this.basedir);
                    cfg.put("port", this.port);
                    cfg.put("context", this.getContext());
                    cfg.put("war", this.getWar());
                    IReusable reusable = (IReusable)reusables.get((Object)this.getName());
                    if (reusable != null && reusable.canReuse(cfg)) {
                        reusable.reset();
                        this.saveGlobal(context, this.getName(), reusable.getObject());
                        result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                        if (UtilLog.LOG.isInfoEnabled()) {
                            UtilLog.LOG.info("Tomcat (" + this.getName() + "/" + reusable.getObject() + ") reused.");
                        }
                        return ENext.DEEP;
                    }
                }
                final Tomcat server = this.createServer();
                if (this.dynamic.booleanValue()) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Jetty dynamic port lookup.");
                    }
                    this.scanAvailablePort(server);
                }
                this.waitForStart(server);
                this.saveGlobal(context, this.getName(), server);
                if (this.reuse.booleanValue()) {
                    if (UtilLog.LOG.isInfoEnabled()) {
                        UtilLog.LOG.info("Tomcat reuse enabled.");
                    }
                    reusables.put((Object)this.getName(), (Object)new AbstractReusable<Tomcat>(this.getName(), server){

                        public boolean canReuse(Map<String, Object> cfg) {
                            Object tmpName = cfg.get("name");
                            Object tmpBasedir = cfg.get("basedir");
                            Object tmpPort = cfg.get("port");
                            Object tmpContext = cfg.get("context");
                            Object tmpWar = cfg.get("war");
                            return tmpName != null && tmpName.equals(PluginStartTomcat.this.getName()) && tmpBasedir != null && tmpBasedir.equals(PluginStartTomcat.this.getBasedir()) && tmpPort != null && tmpPort.equals(PluginStartTomcat.this.getPort()) && tmpContext != null && tmpContext.equals(PluginStartTomcat.this.getContext()) && tmpWar != null && tmpWar.equals(PluginStartTomcat.this.getWar());
                        }

                        public void reset() {
                        }

                        public void release() {
                            block3: {
                                try {
                                    server.stop();
                                    if (UtilLog.LOG.isDebugEnabled()) {
                                        UtilLog.LOG.debug("Tomcat stopped.");
                                    }
                                }
                                catch (LifecycleException e) {
                                    if (!UtilLog.LOG.isDebugEnabled()) break block3;
                                    UtilLog.LOG.debug("Tomcat stopped with fail.", (Throwable)e);
                                }
                            }
                        }
                    });
                }
                result.addResult((Status)Success.INSTANCE, (IBlock)context.peek());
                if (!this.reuse.booleanValue() && UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Tomcat started and ready.");
                }
                context.saveGlobal(this.getName(), (Object)server);
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
        }
        return ENext.DEEP;
    }

    protected Tomcat createServer() {
        Tomcat tomcat = new Tomcat();
        tomcat.setBaseDir(this.getBasedir());
        tomcat.setPort(this.getPort().intValue());
        Context c = tomcat.addWebapp(null, "/" + this.getContext(), new File(this.getWar()).getAbsolutePath());
        c.setReloadable(true);
        return tomcat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanAvailablePort(Tomcat server) throws PluginException {
        boolean available = false;
        int tries = 1000;
        for (int i = this.port.intValue(); !available && i < this.port + 1000; ++i) {
            InputStream in = null;
            Socket sock = null;
            try {
                sock = new Socket("localhost", i);
                in = sock.getInputStream();
                continue;
            }
            catch (Exception e) {
                this.port = i;
                available = true;
                continue;
            }
            finally {
                block24: {
                    block23: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                if (!UtilLog.LOG.isTraceEnabled()) break block23;
                                UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (sock != null) {
                        try {
                            sock.close();
                        }
                        catch (Exception e) {
                            if (!UtilLog.LOG.isTraceEnabled()) break block24;
                            UtilLog.LOG.trace(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (!available) {
            throw new PluginException("No available port from '" + (this.port - 1000) + "' to '" + this.port + "'.");
        }
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Tomcat port '" + this.port + "' available.");
        }
        server.setPort(this.port.intValue());
        if (UtilLog.LOG.isInfoEnabled()) {
            UtilLog.LOG.info("Tomcat port set to '" + this.port + "'.");
        }
    }

    protected void waitForStart(Tomcat server) throws Exception {
        server.start();
    }
}

