/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.openqa.selenium.WebDriver;
import org.specrunner.SRServices;
import org.specrunner.context.IBlock;
import org.specrunner.context.IContext;
import org.specrunner.dumper.core.ConstantsDumperFile;
import org.specrunner.features.IFeatureManager;
import org.specrunner.parameters.IParameterHolder;
import org.specrunner.parameters.core.UtilParametrized;
import org.specrunner.plugins.PluginException;
import org.specrunner.plugins.core.AbstractPluginValue;
import org.specrunner.result.IResultSet;
import org.specrunner.result.Status;
import org.specrunner.result.status.Failure;
import org.specrunner.util.UtilIO;
import org.specrunner.util.UtilLog;
import org.specrunner.util.xom.UtilNode;
import org.specrunner.webdriver.IHtmlUnitDriver;
import org.specrunner.webdriver.IWait;
import org.specrunner.webdriver.impl.WaitDefault;

public abstract class AbstractPluginBrowserAware
extends AbstractPluginValue {
    public static final String FEATURE_IWAIT = AbstractPluginBrowserAware.class.getName() + ".iwait";
    protected IWait iwait;
    public static final String FEATURE_DIR = AbstractPluginBrowserAware.class.getName() + ".dir";
    protected String dir;
    protected String download;

    public IWait getIwait() {
        return this.iwait;
    }

    public void setIwait(IWait iwait) {
        this.iwait = iwait;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDownload() {
        return this.download;
    }

    public void setDownload(String download) {
        this.download = download;
    }

    public void initialize(IContext context) throws PluginException {
        super.initialize(context);
        IFeatureManager fm = SRServices.getFeatureManager();
        fm.set(FEATURE_IWAIT, (Object)this);
        fm.set(FEATURE_DIR, (Object)this);
        if (this.iwait == null) {
            this.setIwait(new WaitDefault());
        }
        this.iwait.reset();
    }

    public void doEnd(IContext context, IResultSet result) throws PluginException {
        String tmp = this.getBrowserName();
        WebDriver client = (WebDriver)context.getByName(tmp);
        if (client == null) {
            result.addResult((Status)Failure.INSTANCE, (IBlock)context.peek(), (Throwable)new PluginException("Browser instance named '" + tmp + "' not created. See PluginBrowser."));
            return;
        }
        IWait instance = this.getWaitInstance(context, result, client);
        if (instance.isWaitForClient(context, result, client)) {
            instance.waitForClient(context, result, client);
        }
        this.doEnd(context, result, client);
        if (this.download != null) {
            this.saveDownload(context, result, client);
        }
    }

    public IWait getWaitInstance(IContext context, IResultSet result, WebDriver client) throws PluginException {
        UtilParametrized.setProperties((IContext)context, (IParameterHolder)this.iwait, (Map)this.getParameters().getAllParameters());
        return this.iwait;
    }

    private void saveDownload(IContext context, IResultSet result, WebDriver client) throws PluginException {
        WebClient wc;
        WebWindow window;
        if (client instanceof IHtmlUnitDriver && (window = (wc = ((IHtmlUnitDriver)client).getWebClient()).getCurrentWindow()) != null) {
            Page tmp = window.getEnclosedPage();
            if (tmp instanceof UnexpectedPage) {
                WebResponse response = tmp.getWebResponse();
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Binary file: " + response.getContentType());
                }
                UnexpectedPage up = (UnexpectedPage)tmp;
                IFeatureManager fm = SRServices.getFeatureManager();
                File outputDirectory = this.dir != null ? new File(this.dir) : (File)fm.get((Object)ConstantsDumperFile.FEATURE_OUTPUT_DIRECTORY);
                File outputFile = new File(outputDirectory, this.download);
                File outputParent = outputFile.getAbsoluteFile().getParentFile();
                if (!outputParent.exists() && !outputParent.mkdirs()) {
                    throw new PluginException("Could not create binary target directory:" + outputParent.getAbsolutePath());
                }
                if (UtilLog.LOG.isInfoEnabled()) {
                    UtilLog.LOG.info("Download file to '" + outputFile.getAbsolutePath() + "'.");
                }
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    in = up.getInputStream();
                    out = new FileOutputStream(outputFile);
                    UtilIO.writeTo((InputStream)in, (OutputStream)out);
                }
                catch (FileNotFoundException e) {
                    throw new PluginException((Throwable)e);
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        throw new PluginException((Throwable)e);
                    }
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (IOException e) {
                        throw new PluginException((Throwable)e);
                    }
                }
                Node node = context.getNode();
                if (node instanceof Element) {
                    Element span = new Element("span");
                    UtilNode.setIgnore((Node)span);
                    span.addAttribute(new Attribute("class", "binary"));
                    span.appendChild(" [");
                    Element a = new Element("a");
                    a.addAttribute(new Attribute("href", outputFile.getAbsolutePath()));
                    a.appendChild(outputFile.getName() + " (" + response.getContentType() + ")");
                    span.appendChild((Node)a);
                    span.appendChild("] ");
                    Element e = (Element)node;
                    e.appendChild((Node)span);
                }
            }
            window.getHistory().back();
        }
    }

    public String getBrowserName() {
        return this.getName() != null ? this.getName() : "browser";
    }

    protected abstract void doEnd(IContext var1, IResultSet var2, WebDriver var3) throws PluginException;
}

