/*
 * Decompiled with CFR 0.152.
 */
package org.specrunner.webdriver.impl;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.specrunner.util.UtilLog;
import org.specrunner.webdriver.AbstractPluginFind;
import org.specrunner.webdriver.IPrepare;

public class PrepareDefault
implements IPrepare {
    @Override
    public void prepare(AbstractPluginFind source, WebDriver client, WebElement ... elements) {
        if (client instanceof JavascriptExecutor) {
            JavascriptExecutor executor = (JavascriptExecutor)client;
            if (elements != null) {
                for (WebElement e : elements) {
                    if (e == null) continue;
                    try {
                        Point location = e.getLocation();
                        if (location == null) continue;
                        executor.executeScript("arguments[0].focus()", new Object[]{e});
                        executor.executeScript("window.scrollTo(" + location.getX() + "," + location.getY() + ")", new Object[0]);
                    }
                    catch (WebDriverException ex) {
                        if (!UtilLog.LOG.isTraceEnabled()) continue;
                        UtilLog.LOG.trace(ex.getMessage(), (Object)e);
                    }
                }
            }
        }
    }
}

