/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.amf.primitives;

import io.github.thibaultbee.streampack.internal.muxers.flv.amf.AmfParameter;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.AmfType;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.primitives.AmfInt16;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.primitives.AmfInt32;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/amf/primitives/AmfString;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/amf/AmfParameter;", "s", "", "(Ljava/lang/String;)V", "size", "", "getSize", "()I", "encode", "", "buffer", "Ljava/nio/ByteBuffer;", "core_release"})
public final class AmfString
extends AmfParameter {
    @NotNull
    private final String s;

    public AmfString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.s = s;
    }

    @Override
    public int getSize() {
        return 3 + this.s.length();
    }

    @Override
    public void encode(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.s.length() < 65536) {
            buffer.put(AmfType.STRING.getValue());
            new AmfInt16(this.s.length()).encode(buffer);
        } else {
            buffer.put(AmfType.LONG_STRING.getValue());
            new AmfInt32(this.s.length()).encode(buffer);
        }
        String string = this.s;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        buffer.put(byArray);
    }
}

