/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005\u001a\u0012\u0010\u000e\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005\u001a\u0012\u0010\u000e\u001a\u00020\b*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0014"}, d2={"extractArray", "", "Ljava/nio/ByteBuffer;", "indexesOf", "", "", "prefix", "put", "", "i", "i1", "s", "", "putInt24", "putShort", "l", "", "putString", "", "slices", "core_release"})
public final class ByteBufferExtensionsKt {
    public static final void put(@NotNull ByteBuffer $this$put, int i, int i1) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put(i, (byte)i1);
    }

    public static final void put(@NotNull ByteBuffer $this$put, short s) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put((byte)s);
    }

    public static final void put(@NotNull ByteBuffer $this$put, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        $this$put.put((byte)i);
    }

    public static final void putInt24(@NotNull ByteBuffer $this$putInt24, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putInt24, (String)"<this>");
        ByteBufferExtensionsKt.putShort($this$putInt24, i >> 8);
        $this$putInt24.put((byte)i);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, long l) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)l);
    }

    public static final void putShort(@NotNull ByteBuffer $this$putShort, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$putShort, (String)"<this>");
        $this$putShort.putShort((short)i);
    }

    public static final void putString(@NotNull ByteBuffer $this$putString, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$putString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = s.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        for (byte c : byArray) {
            $this$putString.put(c);
        }
    }

    @NotNull
    public static final List<Integer> indexesOf(@NotNull ByteBuffer $this$indexesOf, @NotNull byte[] prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$indexesOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (prefix.length == 0) {
            return CollectionsKt.emptyList();
        }
        List indexes = new ArrayList();
        int n = 0;
        int n2 = $this$indexesOf.limit() - prefix.length + 1;
        block0: while (n < n2) {
            int i = n++;
            int n3 = 0;
            int n4 = prefix.length;
            while (n3 < n4) {
                int j;
                if ($this$indexesOf.get(i + (j = n3++)) == prefix[j]) continue;
                continue block0;
            }
            indexes.add(i);
        }
        return indexes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ByteBuffer> slices(@NotNull ByteBuffer $this$slices, @NotNull byte[] prefix) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$slices, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List slices = new ArrayList();
        List<Integer> indexes = ByteBufferExtensionsKt.indexesOf($this$slices, prefix);
        Iterable $this$forEachIndexed$iv = indexes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void i;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl = false;
            int nextPosition = CollectionsKt.getIndices((Collection)indexes).contains(index + 1) ? ((Number)indexes.get(index + 1)).intValue() - 1 : $this$slices.limit() - 1;
            slices.add(new Pair((Object)((int)i), (Object)nextPosition));
        }
        byte[] array = $this$slices.array();
        Iterable $this$map$iv = slices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)array, (String)"array");
            collection.add(ByteBuffer.wrap(ArraysKt.sliceArray((byte[])array, (IntRange)new IntRange(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue()))));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] extractArray(@NotNull ByteBuffer $this$extractArray) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$extractArray, (String)"<this>");
        if ($this$extractArray.hasArray() && !$this$extractArray.isDirect()) {
            byte[] byArray2 = $this$extractArray.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n        this.array()\n    }");
            byArray = byArray2;
        } else {
            void var1_2;
            byte[] byteArray = new byte[$this$extractArray.remaining()];
            $this$extractArray.get(byteArray);
            byArray = var1_2;
        }
        return byArray;
    }
}

