/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv;

import android.content.Context;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.flv.FlvMuxerHelper;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FlvHeader;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FlvTagFactory;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.OnMetadata;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020'H\u0016J\b\u0010/\u001a\u00020'H\u0002J\b\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxer;", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "context", "Landroid/content/Context;", "listener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "initialStreams", "", "Lio/github/thibaultbee/streampack/data/Config;", "writeToFile", "", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Ljava/util/List;Z)V", "hasAudio", "getHasAudio", "()Z", "hasVideo", "getHasVideo", "helper", "Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxerHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/internal/muxers/flv/FlvMuxerHelper;", "getListener", "()Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "setListener", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;)V", "manageVideoOrientation", "getManageVideoOrientation", "setManageVideoOrientation", "(Z)V", "startUpTime", "", "Ljava/lang/Long;", "streams", "", "addStreams", "", "", "streamsConfig", "configure", "", "config", "(Lkotlin/Unit;)V", "encode", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "streamPid", "release", "requireStreams", "startStream", "stopStream", "core_release"})
public final class FlvMuxer
implements IMuxer {
    @NotNull
    private final Context context;
    @Nullable
    private IMuxerListener listener;
    private final boolean writeToFile;
    @NotNull
    private final FlvMuxerHelper helper;
    @NotNull
    private final List<Config> streams;
    @Nullable
    private Long startUpTime;
    private boolean manageVideoOrientation;

    public FlvMuxer(@NotNull Context context, @Nullable IMuxerListener listener, @Nullable List<? extends Config> initialStreams, boolean writeToFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.listener = listener;
        this.writeToFile = writeToFile;
        this.helper = new FlvMuxerHelper();
        this.streams = new ArrayList();
        List<? extends Config> list = initialStreams;
        if (list != null) {
            List<? extends Config> it = list;
            boolean bl = false;
            this.streams.addAll((Collection<Config>)it);
        }
    }

    public /* synthetic */ FlvMuxer(Context context, IMuxerListener iMuxerListener, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iMuxerListener = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        this(context, iMuxerListener, list, bl);
    }

    @Override
    @Nullable
    public IMuxerListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable IMuxerListener iMuxerListener) {
        this.listener = iMuxerListener;
    }

    @Override
    @NotNull
    public FlvMuxerHelper getHelper() {
        return this.helper;
    }

    private final boolean getHasAudio() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.streams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Config it = (Config)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isAudio(it.getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean getHasVideo() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.streams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Config it = (Config)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isVideo(it.getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean getManageVideoOrientation() {
        return this.manageVideoOrientation;
    }

    @Override
    public void setManageVideoOrientation(boolean bl) {
        this.manageVideoOrientation = bl;
    }

    @Override
    public void encode(@NotNull Frame frame, int streamPid) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        long l = frame.getPts();
        Long l2 = this.startUpTime;
        Intrinsics.checkNotNull((Object)l2);
        frame.setPts(l - l2);
        List<FlvTag> flvTags = new FlvTagFactory(frame, true, this.streams.get(streamPid)).build();
        Iterable $this$forEach$iv = flvTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlvTag it = (FlvTag)element$iv;
            boolean bl = false;
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener == null) continue;
            iMuxerListener.onOutputFrame(new Packet(it.write(), frame.getPts()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Config, Integer> addStreams(@NotNull List<? extends Config> streamsConfig) {
        Intrinsics.checkNotNullParameter(streamsConfig, (String)"streamsConfig");
        Map streamMap = new LinkedHashMap();
        this.streams.addAll((Collection<Config>)streamsConfig);
        this.requireStreams();
        Iterable $this$forEachIndexed$iv = this.streams;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void config;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Config config2 = (Config)item$iv;
            int index = n;
            boolean bl = false;
            Map map = streamMap;
            Integer n2 = index;
            map.put(config, n2);
        }
        return streamMap;
    }

    @Override
    public void configure(@NotNull Unit config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }

    @Override
    public void startStream() {
        if (this.writeToFile) {
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener != null) {
                iMuxerListener.onOutputFrame(new Packet(new FlvHeader(this.getHasAudio(), this.getHasVideo()).write(), 0L));
            }
        }
        IMuxerListener iMuxerListener = this.getListener();
        if (iMuxerListener != null) {
            iMuxerListener.onOutputFrame(new Packet(new OnMetadata(this.context, this.getManageVideoOrientation(), this.streams).write(), TimeUtils.INSTANCE.currentTime()));
        }
        this.startUpTime = TimeUtils.INSTANCE.currentTime();
    }

    @Override
    public void stopStream() {
        this.startUpTime = null;
        this.streams.clear();
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - void declaration
     */
    private final void requireStreams() {
        boolean bl;
        Config it;
        int count$iv;
        int n;
        Iterable $this$count$iv = this.streams;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Config)element$iv;
                boolean bl2 = false;
                if (!StringExtensionsKt.isAudio(it.getMimeType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (!(n <= 1)) {
            boolean $i$a$-require-FlvMuxer$requireStreams$32 = false;
            String $i$a$-require-FlvMuxer$requireStreams$32 = "Only one audio stream is supported by FLV";
            throw new IllegalArgumentException($i$a$-require-FlvMuxer$requireStreams$32.toString());
        }
        $this$count$iv = this.streams;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            bl = false;
        } else {
            void var3_5;
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Config)element$iv;
                boolean bl3 = false;
                if (!StringExtensionsKt.isVideo(it.getMimeType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            bl = var3_5;
        }
        if (!(bl <= true)) {
            boolean bl4 = false;
            String string = "Only one video stream is supported by FLV";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

