/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.packet;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.AudioSpecificConfig;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.SoundFormat;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.SoundRate;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.SoundSize;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.SoundType;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.TagType;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/AudioTag;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/FlvTag;", "pts", "", "frameBuffer", "Ljava/nio/ByteBuffer;", "isSequenceHeader", "", "audioConfig", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "(JLjava/nio/ByteBuffer;ZLio/github/thibaultbee/streampack/data/AudioConfig;)V", "payloadSize", "", "getPayloadSize", "()I", "tagHeaderSize", "getTagHeaderSize", "computeHeaderSize", "writePayload", "", "buffer", "writeTagHeader", "Companion", "core_release"})
public final class AudioTag
extends FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer frameBuffer;
    private final boolean isSequenceHeader;
    @NotNull
    private final AudioConfig audioConfig;
    private final int tagHeaderSize;
    private final int payloadSize;
    private static final int AUDIO_TAG_HEADER_SIZE = 1;

    public AudioTag(long pts, @NotNull ByteBuffer frameBuffer, boolean isSequenceHeader, @NotNull AudioConfig audioConfig) {
        Intrinsics.checkNotNullParameter((Object)frameBuffer, (String)"frameBuffer");
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        super(pts, TagType.AUDIO, false, 4, null);
        this.frameBuffer = frameBuffer;
        this.isSequenceHeader = isSequenceHeader;
        this.audioConfig = audioConfig;
        this.tagHeaderSize = this.computeHeaderSize();
        this.payloadSize = this.frameBuffer.remaining();
    }

    public /* synthetic */ AudioTag(long l, ByteBuffer byteBuffer, boolean bl, AudioConfig audioConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(l, byteBuffer, bl, audioConfig);
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBufferExtensionsKt.put(buffer, SoundFormat.Companion.fromMimeType(this.audioConfig.getMimeType()).getValue() << 4 | SoundRate.Companion.fromSampleRate(this.audioConfig.getSampleRate()).getValue() << 2 | SoundSize.Companion.fromByteFormat(this.audioConfig.getByteFormat()).getValue() << 1 | SoundType.Companion.fromChannelConfig(this.audioConfig.getChannelConfig()).getValue());
        if (Intrinsics.areEqual((Object)this.audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            if (this.isSequenceHeader) {
                buffer.put((byte)0);
            } else {
                buffer.put((byte)1);
            }
        }
    }

    @Override
    protected int getTagHeaderSize() {
        return this.tagHeaderSize;
    }

    private final int computeHeaderSize() {
        int size = 1;
        if (Intrinsics.areEqual((Object)this.audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            ++size;
        }
        return size;
    }

    @Override
    protected void writePayload(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.isSequenceHeader) {
            new AudioSpecificConfig(this.frameBuffer, this.audioConfig).write(buffer);
        } else {
            buffer.put(this.frameBuffer);
        }
    }

    @Override
    protected int getPayloadSize() {
        return this.payloadSize;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/AudioTag$Companion;", "", "()V", "AUDIO_TAG_HEADER_SIZE", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

