/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.packet;

import io.github.thibaultbee.streampack.internal.utils.av.video.H26XKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/HEVCDecoderConfigurationRecord;", "", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "(Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;)V", "ppsNoStartCode", "spsNoStartCode", "vpsNoStartCode", "write", "", "buffer", "ColorFormat", "Companion", "core_release"})
public final class HEVCDecoderConfigurationRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer spsNoStartCode;
    @NotNull
    private final ByteBuffer ppsNoStartCode;
    @NotNull
    private final ByteBuffer vpsNoStartCode;
    private static final int HEVC_DECODER_CONFIGURATION_RECORD_SIZE = 11;

    public HEVCDecoderConfigurationRecord(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @NotNull ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
        this.spsNoStartCode = H26XKt.removeStartCode(sps);
        this.ppsNoStartCode = H26XKt.removeStartCode(pps);
        this.vpsNoStartCode = H26XKt.removeStartCode(vps);
    }

    public final void write(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.put((byte)1);
        throw new NotImplementedError("HEVC is not supported yet");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/HEVCDecoderConfigurationRecord$Companion;", "", "()V", "HEVC_DECODER_CONFIGURATION_RECORD_SIZE", "", "getSize", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSize(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @NotNull ByteBuffer vps) {
            Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
            Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
            int size = 11 + sps.remaining() - H26XKt.getStartCodeSize(sps) + pps.remaining() - H26XKt.getStartCodeSize(pps) + vps.remaining() - H26XKt.getStartCodeSize(vps);
            byte profileIdc = sps.get(1);
            switch (profileIdc) {
                case 100: 
                case 110: 
                case 122: 
                case 144: {
                    size += 4;
                }
            }
            return size;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/HEVCDecoderConfigurationRecord$ColorFormat;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "YUV400", "YUV420", "YUV422", "YUV444", "core_release"})
    public static final class ColorFormat
    extends Enum<ColorFormat> {
        private final int value;
        public static final /* enum */ ColorFormat YUV400 = new ColorFormat(0);
        public static final /* enum */ ColorFormat YUV420 = new ColorFormat(1);
        public static final /* enum */ ColorFormat YUV422 = new ColorFormat(2);
        public static final /* enum */ ColorFormat YUV444 = new ColorFormat(3);
        private static final /* synthetic */ ColorFormat[] $VALUES;

        private ColorFormat(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static ColorFormat[] values() {
            return (ColorFormat[])$VALUES.clone();
        }

        public static ColorFormat valueOf(String value) {
            return Enum.valueOf(ColorFormat.class, value);
        }

        static {
            $VALUES = colorFormatArray = new ColorFormat[]{ColorFormat.YUV400, ColorFormat.YUV420, ColorFormat.YUV422, ColorFormat.YUV444};
        }
    }
}

