/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources;

import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.sources.IAudioCapture;
import io.github.thibaultbee.streampack.internal.utils.TimeUtils;
import io.github.thibaultbee.streampack.logger.ILogger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/thibaultbee/streampack/internal/sources/AudioCapture;", "Lio/github/thibaultbee/streampack/internal/sources/IAudioCapture;", "logger", "Lio/github/thibaultbee/streampack/logger/ILogger;", "(Lio/github/thibaultbee/streampack/logger/ILogger;)V", "audioRecord", "Landroid/media/AudioRecord;", "isMuted", "", "()Z", "setMuted", "(Z)V", "getLogger", "()Lio/github/thibaultbee/streampack/logger/ILogger;", "mutedByteArray", "", "audioRecordErrorToString", "", "audioRecordError", "", "configure", "", "config", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "getFrame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "getTimestamp", "", "isRunning", "release", "startStream", "stopStream", "core_release"})
public final class AudioCapture
implements IAudioCapture {
    @NotNull
    private final ILogger logger;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private byte[] mutedByteArray;
    private boolean isMuted;

    public AudioCapture(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public void setMuted(boolean bl) {
        this.isMuted = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@NotNull AudioConfig config) {
        void it;
        AudioRecord audioRecord;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int bufferSize = AudioRecord.getMinBufferSize((int)config.getSampleRate(), (int)config.getChannelConfig(), (int)config.getByteFormat());
        if (bufferSize <= 0) {
            throw new IllegalArgumentException(this.audioRecordErrorToString(bufferSize));
        }
        this.mutedByteArray = new byte[bufferSize];
        AudioRecord audioRecord2 = audioRecord = new AudioRecord(0, config.getSampleRate(), config.getChannelConfig(), config.getByteFormat(), bufferSize);
        AudioCapture audioCapture = this;
        boolean bl = false;
        if (config.getEnableEchoCanceler()) {
            if (AcousticEchoCanceler.isAvailable()) {
                AcousticEchoCanceler.create((int)it.getAudioSessionId()).setEnabled(true);
            } else {
                ILogger.DefaultImpls.e$default(this.getLogger(), this, "Acoustic echo canceler is not available", null, 4, null);
            }
        }
        if (config.getEnableNoiseSuppressor()) {
            if (NoiseSuppressor.isAvailable()) {
                NoiseSuppressor.create((int)it.getAudioSessionId()).setEnabled(true);
            } else {
                ILogger.DefaultImpls.e$default(this.getLogger(), this, "Noise suppressor is not available", null, 4, null);
            }
        }
        audioCapture.audioRecord = audioRecord;
        AudioRecord audioRecord3 = this.audioRecord;
        if (!(audioRecord3 == null ? false : audioRecord3.getState() == 1)) {
            throw new IllegalArgumentException("Failed to initialized AudioRecord");
        }
    }

    @Override
    public void startStream() {
        Unit unit;
        Unit unit2;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord == null) {
            unit2 = null;
        } else {
            AudioRecord it = audioRecord;
            boolean bl = false;
            it.startRecording();
            if (!this.isRunning()) {
                throw new IllegalStateException("AudioCapture: failed to start recording");
            }
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new IllegalStateException("AudioCapture: run: : No audioRecorder");
        }
    }

    private final boolean isRunning() {
        AudioRecord audioRecord = this.audioRecord;
        return audioRecord == null ? false : audioRecord.getRecordingState() == 3;
    }

    @Override
    public void stopStream() {
        if (!this.isRunning()) {
            ILogger.DefaultImpls.d$default(this.logger, this, "Not running", null, 4, null);
            return;
        }
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.stop();
        }
    }

    @Override
    public void release() {
        this.mutedByteArray = null;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
        }
        this.audioRecord = null;
    }

    private final long getTimestamp(AudioRecord audioRecord) {
        AudioTimestamp timestampOut = new AudioTimestamp();
        long timestamp = -1L;
        if (Build.VERSION.SDK_INT >= 24 && audioRecord.getTimestamp(timestampOut, 0) == 0) {
            timestamp = timestampOut.nanoTime / (long)1000;
        }
        if (timestamp < 0L) {
            timestamp = TimeUtils.INSTANCE.currentTime();
        }
        return timestamp;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            AudioRecord it = audioRecord;
            boolean bl = false;
            int length = it.read(buffer, buffer.remaining());
            if (length >= 0) {
                Frame frame;
                if (this.isMuted()) {
                    Intrinsics.checkNotNull((Object)this.mutedByteArray);
                    buffer.put(this.mutedByteArray, 0, buffer.remaining());
                    buffer.clear();
                    frame = new Frame(buffer, "audio/raw", this.getTimestamp(it), null, false, null, 56, null);
                } else {
                    frame = new Frame(buffer, "audio/raw", this.getTimestamp(it), null, false, null, 56, null);
                }
                return frame;
            }
            throw new IllegalArgumentException(this.audioRecordErrorToString(length));
        }
        throw new IllegalStateException("AudioCapture: getFrame: No audioRecorder");
    }

    private final String audioRecordErrorToString(int audioRecordError) {
        String string;
        switch (audioRecordError) {
            case -3: {
                string = "AudioRecord returns an invalid operation error";
                break;
            }
            case -2: {
                string = "AudioRecord returns a bad value error";
                break;
            }
            case -6: {
                string = "AudioRecord returns a dead object error";
                break;
            }
            default: {
                string = Intrinsics.stringPlus((String)"Unknown audio record error: ", (Object)audioRecordError);
            }
        }
        return string;
    }
}

