/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.os.Build;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationCompat;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00072\b\b\u0001\u0010\u0016\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u0007J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0017\u001a\u00020\u0007J\u001a\u0010\u001a\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/github/thibaultbee/streampack/utils/NotificationUtils;", "", "service", "Landroid/app/Service;", "channelId", "", "notificationId", "", "(Landroid/app/Service;Ljava/lang/String;I)V", "hasNotified", "", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "notificationManager$delegate", "Lkotlin/Lazy;", "cancel", "", "createNotification", "Landroid/app/Notification;", "titleResourceId", "contentResourceId", "iconResourceId", "title", "content", "createNotificationChannel", "nameResourceId", "descriptionResourceId", "notify", "notification", "core_release"})
public final class NotificationUtils {
    @NotNull
    private final Service service;
    @NotNull
    private final String channelId;
    private final int notificationId;
    @NotNull
    private final Lazy notificationManager$delegate;
    private boolean hasNotified;

    public NotificationUtils(@NotNull Service service, @NotNull String channelId, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.service = service;
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.notificationManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationManager>(this){
            final /* synthetic */ NotificationUtils this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationManager invoke() {
                Object object = NotificationUtils.access$getService$p(this.this$0).getSystemService("notification");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
                }
                return (NotificationManager)object;
            }
        }));
    }

    private final NotificationManager getNotificationManager() {
        Lazy lazy = this.notificationManager$delegate;
        return (NotificationManager)lazy.getValue();
    }

    public final void cancel() {
        this.service.stopForeground(true);
        this.hasNotified = false;
    }

    public final void notify(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        if (!this.hasNotified) {
            this.service.startForeground(this.notificationId, notification);
            this.hasNotified = true;
        } else {
            this.getNotificationManager().notify(this.notificationId, notification);
        }
    }

    @NotNull
    public final Notification createNotification(@StringRes int titleResourceId, @StringRes int contentResourceId, @DrawableRes int iconResourceId) {
        String string2 = this.service.getString(titleResourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getString(titleResourceId)");
        return this.createNotification(string2, contentResourceId != 0 ? this.service.getString(contentResourceId) : (String)null, iconResourceId);
    }

    @NotNull
    public final Notification createNotification(@NotNull String title, @Nullable String content, @DrawableRes int iconResourceId) {
        NotificationCompat.Builder builder;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        NotificationCompat.Builder $this$createNotification_u24lambda_u2d1 = builder = new NotificationCompat.Builder((Context)this.service, this.channelId);
        boolean bl = false;
        $this$createNotification_u24lambda_u2d1.setSmallIcon(iconResourceId);
        $this$createNotification_u24lambda_u2d1.setContentTitle((CharSequence)title);
        String string2 = content;
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            $this$createNotification_u24lambda_u2d1.setContentText((CharSequence)it);
        }
        NotificationCompat.Builder builder2 = builder;
        builder = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder.build()");
        return builder;
    }

    public static /* synthetic */ Notification createNotification$default(NotificationUtils notificationUtils2, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = null;
        }
        return notificationUtils2.createNotification(string2, string3, n);
    }

    public final void createNotificationChannel(@StringRes int nameResourceId, @StringRes int descriptionResourceId) {
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = this.service.getSystemService("notification");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            NotificationManager notificationManager2 = (NotificationManager)object;
            String string2 = this.service.getString(nameResourceId);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getString(nameResourceId)");
            String name = string2;
            NotificationChannel channel = new NotificationChannel(this.channelId, (CharSequence)name, 3);
            if (descriptionResourceId != 0) {
                channel.setDescription(this.service.getString(descriptionResourceId));
            }
            notificationManager2.createNotificationChannel(channel);
        }
    }

    public static final /* synthetic */ Service access$getService$p(NotificationUtils $this) {
        return $this.service;
    }
}

