/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.camera;

import android.content.Context;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.util.Range;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.error.CameraError;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraExecutorManager;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraHandlerManager;
import io.github.thibaultbee.streampack.internal.sources.camera.ICameraThreadManager;
import io.github.thibaultbee.streampack.internal.sources.camera.InternalCameraExtensionsKt;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.utils.ExtensionsKt;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u000e*\u0001\u000e\u0018\u00002\u00020\u0001:\u0002@AB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ'\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020\"H\u0002J#\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u0002H'\u0018\u00010)\u00a2\u0006\u0002\u0010*J\u0006\u0010+\u001a\u00020\u0017J!\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\nH\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\u0017J\u000e\u00101\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J \u00102\u001a\u00020\u00172\u0018\u00103\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010)\u0012\u0004\u0012\u00020\u000104J'\u00105\u001a\u00020\u0017\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\u0006\u00106\u001a\u0002H'\u00a2\u0006\u0002\u00107J \u00108\u001a\u00020\u00172\u0018\u00103\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010)\u0012\u0004\u0012\u00020\u000104J'\u00109\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u001c\u0010;\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\"2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ\u0006\u0010<\u001a\u00020\u0017J\u0006\u0010=\u001a\u00020\u0017J\b\u0010>\u001a\u00020\u0017H\u0002J\u0006\u0010?\u001a\u00020\u0017R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006B"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "", "context", "Landroid/content/Context;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Landroid/content/Context;Lkotlinx/coroutines/CoroutineDispatcher;)V", "camera", "Landroid/hardware/camera2/CameraDevice;", "cameraId", "", "getCameraId", "()Ljava/lang/String;", "captureCallback", "io/github/thibaultbee/streampack/internal/sources/camera/CameraController$captureCallback$1", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController$captureCallback$1;", "captureRequest", "Landroid/hardware/camera2/CaptureRequest$Builder;", "captureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "threadManager", "Lio/github/thibaultbee/streampack/internal/sources/camera/ICameraThreadManager;", "addTarget", "", "target", "Landroid/view/Surface;", "addTargets", "targets", "", "createCaptureSession", "(Landroid/hardware/camera2/CameraDevice;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRequestSession", "fpsRange", "Landroid/util/Range;", "", "surfaces", "getClosestFpsRange", "fps", "getSetting", "T", "key", "Landroid/hardware/camera2/CaptureRequest$Key;", "(Landroid/hardware/camera2/CaptureRequest$Key;)Ljava/lang/Object;", "muteVibrationAndSound", "openCamera", "manager", "Landroid/hardware/camera2/CameraManager;", "(Landroid/hardware/camera2/CameraManager;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "release", "removeTarget", "setBurstSettings", "settingsMap", "", "setRepeatingSetting", "value", "(Landroid/hardware/camera2/CaptureRequest$Key;Ljava/lang/Object;)V", "setRepeatingSettings", "startCamera", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startRequestSession", "stopCamera", "unmuteVibrationAndSound", "updateBurstSession", "updateRepeatingSession", "CameraCaptureSessionCallback", "CameraDeviceCallback", "core_release"})
public final class CameraController {
    @NotNull
    private final Context context;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @Nullable
    private CameraDevice camera;
    @Nullable
    private CameraCaptureSession captureSession;
    @Nullable
    private CaptureRequest.Builder captureRequest;
    @NotNull
    private final ICameraThreadManager threadManager;
    @NotNull
    private final captureCallback.1 captureCallback;

    public CameraController(@NotNull Context context, @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this.context = context;
        this.coroutineDispatcher = coroutineDispatcher;
        this.threadManager = Build.VERSION.SDK_INT >= 28 ? (ICameraThreadManager)new CameraExecutorManager() : (ICameraThreadManager)new CameraHandlerManager();
        this.captureCallback = new CameraCaptureSession.CaptureCallback(){

            public void onCaptureFailed(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull CaptureFailure failure) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
                super.onCaptureFailed(session, request, failure);
                ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)((Object)this)), Intrinsics.stringPlus((String)"Capture failed  with code ", (Object)failure.getReason()), null, 4, null);
            }
        };
    }

    public /* synthetic */ CameraController(Context context, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        this(context, coroutineDispatcher);
    }

    @Nullable
    public final String getCameraId() {
        CameraDevice cameraDevice = this.camera;
        return cameraDevice == null ? null : cameraDevice.getId();
    }

    /*
     * WARNING - void declaration
     */
    private final Range<Integer> getClosestFpsRange(String cameraId2, int fps) {
        void $this$filterTo$iv$iv;
        List fpsRangeList = InternalCameraExtensionsKt.getCameraFpsList(this.context, cameraId2);
        ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), Intrinsics.stringPlus((String)"Supported FPS range list: ", fpsRangeList), null, 4, null);
        Iterable $this$filter$iv = fpsRangeList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Range it = (Range)element$iv$iv;
            boolean bl = false;
            if (!(it.contains((Comparable)Integer.valueOf(fps)) | it.contains((Comparable)Integer.valueOf(fps * 1000)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fpsRangeList = (List)destination$iv$iv;
        if (fpsRangeList.isEmpty()) {
            throw new InvalidParameterException(Intrinsics.stringPlus((String)"Failed to find a single FPS range that contains ", (Object)fps));
        }
        Range selectedFpsRange = null;
        selectedFpsRange = (Range)fpsRangeList.get(0);
        fpsRangeList = CollectionsKt.drop((Iterable)fpsRangeList, (int)0);
        Iterable $this$forEach$iv = fpsRangeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Range it = (Range)element$iv;
            boolean bl = false;
            int n = ((Number)((Object)it.getUpper())).intValue();
            Comparable comparable = it.getLower();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"it.lower");
            int n2 = n - ((Number)((Object)comparable)).intValue();
            int n3 = ((Number)((Object)((Range)selectedFpsRange).getUpper())).intValue();
            comparable = ((Range)selectedFpsRange).getLower();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"selectedFpsRange.lower");
            if (n2 >= n3 - ((Number)((Object)comparable)).intValue()) continue;
            selectedFpsRange = it;
        }
        ILogger.DefaultImpls.d$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), Intrinsics.stringPlus((String)"Selected Fps range ", selectedFpsRange), null, 4, null);
        return selectedFpsRange;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    private final Object openCamera(CameraManager manager, String cameraId2, Continuation<? super CameraDevice> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super CameraDevice> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.threadManager.openCamera(manager, cameraId2, new CameraDeviceCallback((CancellableContinuation<? super CameraDevice>)cont));
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final Object createCaptureSession(CameraDevice camera, List<? extends Surface> targets, Continuation<? super CameraCaptureSession> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super CameraCaptureSession> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.threadManager.createCaptureSession(camera, targets, new CameraCaptureSessionCallback((CancellableContinuation<? super CameraCaptureSession>)cont));
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final CaptureRequest.Builder createRequestSession(CameraDevice camera, CameraCaptureSession captureSession, Range<Integer> fpsRange, List<? extends Surface> surfaces) {
        if (surfaces.isEmpty()) {
            throw new RuntimeException("No target surface");
        }
        CaptureRequest.Builder builder = camera.createCaptureRequest(3);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"camera.createCaptureRequ\u2026raDevice.TEMPLATE_RECORD)");
        CaptureRequest.Builder $this$createRequestSession_u24lambda_u2d5 = builder;
        boolean bl = false;
        Iterable $this$forEach$iv = surfaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Surface it = (Surface)element$iv;
            boolean bl2 = false;
            $this$createRequestSession_u24lambda_u2d5.addTarget(it);
        }
        $this$createRequestSession_u24lambda_u2d5.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, fpsRange);
        CaptureRequest captureRequest = $this$createRequestSession_u24lambda_u2d5.build();
        Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"build()");
        this.threadManager.setRepeatingSingleRequest(captureSession, captureRequest, this.captureCallback);
        return builder;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    @Nullable
    public final Object startCamera(@NotNull String cameraId2, @NotNull List<? extends Surface> targets, @NotNull Continuation<? super Unit> $completion) {
        if (!(!((Collection)targets).isEmpty())) {
            boolean bl = false;
            String string = " At least one target is required";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cameraId2, targets, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ CameraController this$0;
            final /* synthetic */ String $cameraId;
            final /* synthetic */ List<Surface> $targets;
            {
                this.this$0 = $receiver;
                this.$cameraId = $cameraId;
                this.$targets = $targets;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = CameraController.access$getContext$p(this.this$0).getSystemService("camera");
                        if (v0 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
                        }
                        manager = (CameraManager)v0;
                        var9_4 = this.this$0;
                        this.L$0 = var9_4;
                        this.label = 1;
                        v1 = CameraController.access$openCamera(this.this$0, manager, this.$cameraId, (Continuation)this);
                        if (v1 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        var9_4 = (CameraController)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl20:
                        // 2 sources

                        var3_5 = v1;
                        var4_6 = this.this$0;
                        var5_7 = this.$targets;
                        var6_8 = (CameraDevice)var3_5;
                        $i$a$-also-CameraController$startCamera$3$1 = false;
                        var8_11 = var4_6;
                        this.L$0 = var3_5;
                        this.L$1 = var8_11;
                        this.L$2 = var9_4;
                        this.label = 2;
                        v2 = CameraController.access$createCaptureSession(var4_6, (CameraDevice)cameraDevice, var5_7, (Continuation)this);
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl41
                    }
                    case 2: {
                        $i$a$-also-CameraController$startCamera$3$1 = false;
                        var9_4 = (CameraController)this.L$2;
                        var8_11 = (CameraController)this.L$1;
                        var3_5 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl41:
                        // 2 sources

                        CameraController.access$setCaptureSession$p(var8_11, (CameraCaptureSession)v2);
                        CameraController.access$setCamera$p(var9_4, (CameraDevice)var3_5);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void startRequestSession(int fps, @NotNull List<? extends Surface> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        if (!(this.camera != null)) {
            boolean $i$a$-require-CameraController$startRequestSession$42 = false;
            String $i$a$-require-CameraController$startRequestSession$42 = "Camera must not be null";
            throw new IllegalArgumentException($i$a$-require-CameraController$startRequestSession$42.toString());
        }
        if (!(this.captureSession != null)) {
            boolean $i$a$-require-CameraController$startRequestSession$52 = false;
            String $i$a$-require-CameraController$startRequestSession$52 = "Capture session must not be null";
            throw new IllegalArgumentException($i$a$-require-CameraController$startRequestSession$52.toString());
        }
        if (!(!((Collection)targets).isEmpty())) {
            boolean bl = false;
            String string = " At least one target is required";
            throw new IllegalArgumentException(string.toString());
        }
        CameraDevice cameraDevice = this.camera;
        Intrinsics.checkNotNull((Object)cameraDevice);
        CameraCaptureSession cameraCaptureSession = this.captureSession;
        Intrinsics.checkNotNull((Object)cameraCaptureSession);
        CameraDevice cameraDevice2 = this.camera;
        Intrinsics.checkNotNull((Object)cameraDevice2);
        String string = cameraDevice2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"camera!!.id");
        this.captureRequest = this.createRequestSession(cameraDevice, cameraCaptureSession, this.getClosestFpsRange(string, fps), targets);
    }

    public final void stopCamera() {
        this.captureRequest = null;
        CameraCaptureSession cameraCaptureSession = this.captureSession;
        if (cameraCaptureSession != null) {
            cameraCaptureSession.close();
        }
        this.captureSession = null;
        CameraDevice cameraDevice = this.camera;
        if (cameraDevice != null) {
            cameraDevice.close();
        }
        this.camera = null;
    }

    public final void addTargets(@NotNull List<? extends Surface> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        if (!(this.captureRequest != null)) {
            boolean $i$a$-require-CameraController$addTargets$32 = false;
            String $i$a$-require-CameraController$addTargets$32 = "capture request must not be null";
            throw new IllegalArgumentException($i$a$-require-CameraController$addTargets$32.toString());
        }
        if (!(!((Collection)targets).isEmpty())) {
            boolean $i$a$-require-CameraController$addTargets$42 = false;
            String $i$a$-require-CameraController$addTargets$42 = " At least one target is required";
            throw new IllegalArgumentException($i$a$-require-CameraController$addTargets$42.toString());
        }
        Iterable $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Surface it = (Surface)element$iv;
            boolean bl = false;
            CaptureRequest.Builder builder = this.captureRequest;
            Intrinsics.checkNotNull((Object)builder);
            builder.addTarget(it);
        }
        this.updateRepeatingSession();
    }

    public final void addTarget(@NotNull Surface target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(this.captureRequest != null)) {
            boolean bl = false;
            String string = "capture request must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        CaptureRequest.Builder builder = this.captureRequest;
        Intrinsics.checkNotNull((Object)builder);
        builder.addTarget(target);
        this.updateRepeatingSession();
    }

    public final void removeTarget(@NotNull Surface target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(this.captureRequest != null)) {
            boolean bl = false;
            String string = "capture request must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        CaptureRequest.Builder builder = this.captureRequest;
        Intrinsics.checkNotNull((Object)builder);
        builder.removeTarget(target);
        this.updateRepeatingSession();
    }

    public final void release() {
        this.threadManager.release();
    }

    public final void muteVibrationAndSound() {
        if (Build.VERSION.SDK_INT >= 30) {
            CameraDevice cameraDevice = this.camera;
            if (cameraDevice != null) {
                cameraDevice.setCameraAudioRestriction(3);
            }
        }
    }

    public final void unmuteVibrationAndSound() {
        if (Build.VERSION.SDK_INT >= 30) {
            CameraDevice cameraDevice = this.camera;
            if (cameraDevice != null) {
                cameraDevice.setCameraAudioRestriction(0);
            }
        }
    }

    public final void updateRepeatingSession() {
        if (!(this.captureSession != null)) {
            boolean $i$a$-require-CameraController$updateRepeatingSession$32 = false;
            String $i$a$-require-CameraController$updateRepeatingSession$32 = "capture session must not be null";
            throw new IllegalArgumentException($i$a$-require-CameraController$updateRepeatingSession$32.toString());
        }
        if (!(this.captureRequest != null)) {
            boolean bl = false;
            String string = "capture request must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        CameraCaptureSession cameraCaptureSession = this.captureSession;
        Intrinsics.checkNotNull((Object)cameraCaptureSession);
        CaptureRequest.Builder builder = this.captureRequest;
        Intrinsics.checkNotNull((Object)builder);
        CaptureRequest captureRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"captureRequest!!.build()");
        this.threadManager.setRepeatingSingleRequest(cameraCaptureSession, captureRequest, this.captureCallback);
    }

    private final void updateBurstSession() {
        if (!(this.captureSession != null)) {
            boolean $i$a$-require-CameraController$updateBurstSession$32 = false;
            String $i$a$-require-CameraController$updateBurstSession$32 = "capture session must not be null";
            throw new IllegalArgumentException($i$a$-require-CameraController$updateBurstSession$32.toString());
        }
        if (!(this.captureRequest != null)) {
            boolean bl = false;
            String string = "capture request must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        CameraCaptureSession cameraCaptureSession = this.captureSession;
        Intrinsics.checkNotNull((Object)cameraCaptureSession);
        CaptureRequest.Builder builder = this.captureRequest;
        Intrinsics.checkNotNull((Object)builder);
        this.threadManager.captureBurstRequests(cameraCaptureSession, CollectionsKt.listOf((Object)builder.build()), this.captureCallback);
    }

    @Nullable
    public final <T> T getSetting(@Nullable CaptureRequest.Key<T> key) {
        CaptureRequest.Builder builder = this.captureRequest;
        return (T)(builder == null ? null : builder.get(key));
    }

    public final <T> void setRepeatingSetting(@NotNull CaptureRequest.Key<T> key, T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        CaptureRequest.Builder builder = this.captureRequest;
        if (builder != null) {
            CaptureRequest.Builder it = builder;
            boolean bl = false;
            it.set(key, value);
            this.updateRepeatingSession();
        }
    }

    public final void setRepeatingSettings(@NotNull Map<CaptureRequest.Key<Object>, ? extends Object> settingsMap) {
        Intrinsics.checkNotNullParameter(settingsMap, (String)"settingsMap");
        CaptureRequest.Builder builder = this.captureRequest;
        if (builder != null) {
            CaptureRequest.Builder it = builder;
            boolean bl = false;
            for (Map.Entry<CaptureRequest.Key<Object>, ? extends Object> item : settingsMap.entrySet()) {
                it.set(item.getKey(), item.getValue());
            }
            this.updateRepeatingSession();
        }
    }

    public final void setBurstSettings(@NotNull Map<CaptureRequest.Key<Object>, ? extends Object> settingsMap) {
        Intrinsics.checkNotNullParameter(settingsMap, (String)"settingsMap");
        CaptureRequest.Builder builder = this.captureRequest;
        if (builder != null) {
            CaptureRequest.Builder it = builder;
            boolean bl = false;
            for (Map.Entry<CaptureRequest.Key<Object>, ? extends Object> item : settingsMap.entrySet()) {
                it.set(item.getKey(), item.getValue());
            }
            this.updateBurstSession();
        }
    }

    public static final /* synthetic */ Object access$openCamera(CameraController $this, CameraManager manager, String cameraId2, Continuation $completion) {
        return $this.openCamera(manager, cameraId2, (Continuation<? super CameraDevice>)$completion);
    }

    public static final /* synthetic */ Object access$createCaptureSession(CameraController $this, CameraDevice camera, List targets, Continuation $completion) {
        return $this.createCaptureSession(camera, targets, (Continuation<? super CameraCaptureSession>)$completion);
    }

    public static final /* synthetic */ Context access$getContext$p(CameraController $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$setCamera$p(CameraController $this, CameraDevice cameraDevice) {
        $this.camera = cameraDevice;
    }

    public static final /* synthetic */ void access$setCaptureSession$p(CameraController $this, CameraCaptureSession cameraCaptureSession) {
        $this.captureSession = cameraCaptureSession;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController$CameraDeviceCallback;", "Landroid/hardware/camera2/CameraDevice$StateCallback;", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "Landroid/hardware/camera2/CameraDevice;", "(Lkotlinx/coroutines/CancellableContinuation;)V", "onDisconnected", "", "camera", "onError", "error", "", "onOpened", "device", "core_release"})
    private static final class CameraDeviceCallback
    extends CameraDevice.StateCallback {
        @NotNull
        private final CancellableContinuation<CameraDevice> cont;

        public CameraDeviceCallback(@NotNull CancellableContinuation<? super CameraDevice> cont) {
            Intrinsics.checkNotNullParameter(cont, (String)"cont");
            this.cont = cont;
        }

        public void onOpened(@NotNull CameraDevice device) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            ((Continuation)this.cont).resumeWith(Result.constructor-impl((Object)device));
        }

        public void onDisconnected(@NotNull CameraDevice camera) {
            Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
            ILogger.DefaultImpls.w$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)this), "Camera " + camera.getId() + " has been disconnected", null, 4, null);
        }

        public void onError(@NotNull CameraDevice camera, int error) {
            CameraError exc;
            Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)this), "Camera " + camera.getId() + " is in error " + error, null, 4, null);
            switch (error) {
                case 1: {
                    CameraError cameraError = new CameraError("Camera already in use");
                    break;
                }
                case 2: {
                    CameraError cameraError = new CameraError("Max cameras in use");
                    break;
                }
                case 3: {
                    CameraError cameraError = new CameraError("Camera has been disabled");
                    break;
                }
                case 4: {
                    CameraError cameraError = new CameraError("Camera device has crashed");
                    break;
                }
                case 5: {
                    CameraError cameraError = new CameraError("Camera service has crashed");
                    break;
                }
                default: {
                    CameraError cameraError = exc = new CameraError("Unknown error");
                }
            }
            if (this.cont.isActive()) {
                ((Continuation)this.cont).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exc)));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController$CameraCaptureSessionCallback;", "Landroid/hardware/camera2/CameraCaptureSession$StateCallback;", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "Landroid/hardware/camera2/CameraCaptureSession;", "(Lkotlinx/coroutines/CancellableContinuation;)V", "onConfigureFailed", "", "session", "onConfigured", "core_release"})
    private static final class CameraCaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        @NotNull
        private final CancellableContinuation<CameraCaptureSession> cont;

        public CameraCaptureSessionCallback(@NotNull CancellableContinuation<? super CameraCaptureSession> cont) {
            Intrinsics.checkNotNullParameter(cont, (String)"cont");
            this.cont = cont;
        }

        public void onConfigured(@NotNull CameraCaptureSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ((Continuation)this.cont).resumeWith(Result.constructor-impl((Object)session));
        }

        public void onConfigureFailed(@NotNull CameraCaptureSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)this), "Camera Session configuration failed", null, 4, null);
            ((Continuation)this.cont).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CameraError("Camera: failed to configure the capture session"))));
        }
    }
}

